/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.StandardJdbcMutationExecutor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.NativeJdbcMutation;

public class NativeNonSelectQueryPlanImpl
implements NonSelectQueryPlan {
    private final String sql;
    private final Set<String> affectedTableNames;
    private final List<QueryParameterImplementor<?>> parameterList;

    public NativeNonSelectQueryPlanImpl(String sql, Set<String> affectedTableNames, List<QueryParameterImplementor<?>> parameterList) {
        this.sql = sql;
        this.affectedTableNames = affectedTableNames;
        this.parameterList = parameterList;
    }

    @Override
    public int executeUpdate(ExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        executionContext.getSession().autoFlushIfRequired(this.affectedTableNames);
        BulkOperationCleanupAction.schedule(executionContext, this.affectedTableNames);
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(this.parameterList.size());
            for (QueryParameterImplementor<?> param : this.parameterList) {
                QueryParameterBinding<?> binding = queryParameterBindings.getBinding(param);
                AllowableParameterType<Object> type = binding.getBindType();
                if (type == null) {
                    type = param.getHibernateType();
                }
                if (type == null) {
                    type = executionContext.getSession().getTypeConfiguration().getBasicTypeForJavaType(Object.class);
                }
                JdbcMapping jdbcMapping = ((BasicValuedMapping)((Object)type)).getJdbcMapping();
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                jdbcParameterBinders.add(jdbcParameter);
                jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, binding.getBindValue()));
            }
        }
        NativeJdbcMutation jdbcMutation = new NativeJdbcMutation(this.sql, jdbcParameterBinders, this.affectedTableNames);
        StandardJdbcMutationExecutor executor = StandardJdbcMutationExecutor.INSTANCE;
        SharedSessionContractImplementor session = executionContext.getSession();
        return executor.execute(jdbcMutation, jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

