/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.EmptyScrollableResults;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.sql.internal.ResultSetMappingProcessor;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.query.sql.spi.NativeSelectQueryPlan;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class NativeSelectQueryPlanImpl<R>
implements NativeSelectQueryPlan<R> {
    private final String sql;
    private final Set<String> affectedTableNames;
    private final List<QueryParameterImplementor<?>> parameterList;
    private final JdbcValuesMappingProducer resultSetMapping;

    public NativeSelectQueryPlanImpl(String sql, Set<String> affectedTableNames, List<QueryParameterImplementor<?>> parameterList, ResultSetMapping resultSetMapping, SessionFactoryImplementor sessionFactory) {
        ResultSetMappingProcessor processor = new ResultSetMappingProcessor(resultSetMapping, sessionFactory);
        SQLQueryParser parser = new SQLQueryParser(sql, processor.process(), sessionFactory);
        this.sql = parser.process();
        this.parameterList = parameterList;
        this.resultSetMapping = processor.generateResultMapping(parser.queryHasAliases());
        if (affectedTableNames == null) {
            affectedTableNames = new HashSet<String>();
        }
        if (resultSetMapping != null) {
            resultSetMapping.addAffectedTableNames(affectedTableNames, sessionFactory);
        }
        this.affectedTableNames = affectedTableNames;
    }

    @Override
    public List<R> performList(ExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return Collections.emptyList();
        }
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(this.parameterList.size());
            for (QueryParameterImplementor<?> param : this.parameterList) {
                QueryParameterBinding<?> binding = queryParameterBindings.getBinding(param);
                AllowableParameterType<Object> type = binding.getBindType();
                if (type == null) {
                    type = param.getHibernateType();
                }
                if (type == null) {
                    type = executionContext.getSession().getTypeConfiguration().getBasicTypeForJavaType(Object.class);
                }
                JdbcMapping jdbcMapping = ((BasicValuedMapping)((Object)type)).getJdbcMapping();
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                jdbcParameterBinders.add(jdbcParameter);
                jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, binding.getBindValue()));
            }
        }
        executionContext.getSession().autoFlushIfRequired(this.affectedTableNames);
        JdbcSelect jdbcSelect = new JdbcSelect(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames, Collections.emptySet());
        JdbcSelectExecutorStandardImpl executor = JdbcSelectExecutorStandardImpl.INSTANCE;
        return executor.list(jdbcSelect, jdbcParameterBindings, executionContext, null, ListResultsConsumer.UniqueSemantic.NONE);
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, ExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List<JdbcParameterBinder> jdbcParameterBinders;
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return EmptyScrollableResults.INSTANCE;
        }
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(this.parameterList.size());
            queryParameterBindings.visitBindings((param, binding) -> {
                AllowableParameterType type = binding.getBindType();
                if (type == null) {
                    type = param.getHibernateType();
                }
                if (type == null) {
                    type = executionContext.getSession().getTypeConfiguration().getBasicTypeForJavaType(Object.class);
                }
                JdbcMapping jdbcMapping = ((BasicValuedMapping)((Object)type)).getJdbcMapping();
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                jdbcParameterBinders.add(jdbcParameter);
                jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, binding.getBindValue()));
            });
        }
        JdbcSelect jdbcSelect = new JdbcSelect(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames, Collections.emptySet());
        JdbcSelectExecutorStandardImpl executor = JdbcSelectExecutorStandardImpl.INSTANCE;
        return executor.scroll(jdbcSelect, scrollMode, jdbcParameterBindings, executionContext, null);
    }
}

