/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.internal.AliasConstantsHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.results.ResultSetMappingImpl;
import org.hibernate.query.results.complete.CompleteResultBuilderCollectionStandard;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ResultSetMappingProcessor
implements SQLQueryParser.ParserContext {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ResultSetMappingProcessor.class);
    private final ResultSetMapping resultSetMapping;
    private final Map<String, NativeQuery.ResultNode> alias2Return = new HashMap<String, NativeQuery.ResultNode>();
    private final Map<String, String> alias2OwnerAlias = new HashMap<String, String>();
    private final Map<String, EntityPersister> alias2Persister = new HashMap<String, EntityPersister>();
    private final Map<String, String> alias2Suffix = new HashMap<String, String>();
    private final Map<String, CollectionPersister> alias2CollectionPersister = new HashMap<String, CollectionPersister>();
    private final Map<String, String> alias2CollectionSuffix = new HashMap<String, String>();
    private final Map<String, Map<String, String[]>> entityPropertyResultMaps = new HashMap<String, Map<String, String[]>>();
    private final Map<String, Map<String, String[]>> collectionPropertyResultMaps = new HashMap<String, Map<String, String[]>>();
    private final SessionFactoryImplementor factory;
    private int entitySuffixSeed;
    private int collectionSuffixSeed;

    public ResultSetMappingProcessor(ResultSetMapping resultSetMapping, SessionFactoryImplementor factory) {
        this.resultSetMapping = resultSetMapping;
        this.factory = factory;
    }

    private Map<String, String[]> internalGetPropertyResultsMap(String alias) {
        Map<String, String[]> propertyResultMaps = this.collectionPropertyResultMaps.get(alias);
        if (propertyResultMaps == null) {
            propertyResultMaps = this.entityPropertyResultMaps.get(alias);
        }
        if (propertyResultMaps != null) {
            return propertyResultMaps;
        }
        NativeQuery.ResultNode rtn = this.alias2Return.get(alias);
        if (rtn instanceof NativeQuery.ReturnProperty && !(rtn instanceof NativeQuery.FetchReturn)) {
            return null;
        }
        return Collections.emptyMap();
    }

    private boolean hasPropertyResultMap(String alias) {
        Map<String, String[]> propertyMaps = this.internalGetPropertyResultsMap(alias);
        return propertyMaps != null && !propertyMaps.isEmpty();
    }

    public SQLQueryParser.ParserContext process() {
        this.resultSetMapping.visitResultBuilders((i, resultBuilder) -> {
            if (resultBuilder instanceof NativeQuery.RootReturn) {
                NativeQuery.RootReturn rootReturn = (NativeQuery.RootReturn)((Object)resultBuilder);
                this.alias2Return.put(rootReturn.getTableAlias(), rootReturn);
                resultBuilder.visitFetchBuilders(this::processFetchBuilder);
            } else if (resultBuilder instanceof NativeQuery.CollectionReturn) {
                NativeQuery.CollectionReturn collectionReturn = (NativeQuery.CollectionReturn)((Object)resultBuilder);
                this.alias2Return.put(collectionReturn.getTableAlias(), collectionReturn);
                Map<String, String[]> propertyResultsMap = Collections.emptyMap();
                this.addCollection(collectionReturn.getNavigablePath().getFullPath(), collectionReturn.getTableAlias(), propertyResultsMap);
            }
        });
        this.resultSetMapping.visitLegacyFetchBuilders(fetchBuilder -> {
            this.alias2Return.put(fetchBuilder.getTableAlias(), (NativeQuery.ResultNode)fetchBuilder);
            this.alias2OwnerAlias.put(fetchBuilder.getTableAlias(), fetchBuilder.getOwnerAlias());
        });
        for (NativeQuery.ResultNode queryReturn : this.alias2Return.values()) {
            this.processReturn(queryReturn);
        }
        return this;
    }

    private void processFetchBuilder(String attributeName, FetchBuilder fetchBuilder) {
        if (fetchBuilder instanceof DynamicFetchBuilderLegacy) {
            this.resultSetMapping.addLegacyFetchBuilder((DynamicFetchBuilderLegacy)fetchBuilder);
        } else if (fetchBuilder instanceof NativeQuery.FetchReturn) {
            NativeQuery.FetchReturn fetchReturn = (NativeQuery.FetchReturn)((Object)fetchBuilder);
            this.alias2Return.put(fetchReturn.getTableAlias(), fetchReturn);
            this.alias2OwnerAlias.put(fetchReturn.getTableAlias(), fetchReturn.getOwnerAlias());
        }
        fetchBuilder.visitFetchBuilders(this::processFetchBuilder);
    }

    public ResultSetMapping generateResultMapping(boolean queryHadAliases) {
        if (!queryHadAliases) {
            return this.resultSetMapping;
        }
        ResultSetMappingImpl resultSetMapping = new ResultSetMappingImpl(null);
        HashSet visited = new HashSet();
        this.resultSetMapping.visitResultBuilders((i, resultBuilder) -> {
            if (resultBuilder instanceof NativeQuery.RootReturn) {
                NativeQuery.RootReturn rootReturn = (NativeQuery.RootReturn)((Object)resultBuilder);
                String suffix = this.alias2Suffix.get(rootReturn.getTableAlias());
                visited.add(rootReturn.getTableAlias());
                if (suffix == null) {
                    resultSetMapping.addResultBuilder((ResultBuilder)resultBuilder);
                } else {
                    DynamicResultBuilderEntityStandard resultBuilderEntity = this.createSuffixedResultBuilder(rootReturn, suffix);
                    resultSetMapping.addResultBuilder(resultBuilderEntity);
                    this.alias2Return.put(rootReturn.getTableAlias(), resultBuilderEntity);
                }
            } else if (resultBuilder instanceof NativeQuery.CollectionReturn) {
                NativeQuery.CollectionReturn collectionReturn = (NativeQuery.CollectionReturn)((Object)resultBuilder);
                String suffix = this.alias2CollectionSuffix.get(collectionReturn.getTableAlias());
                if (suffix == null) {
                    resultSetMapping.addResultBuilder((ResultBuilder)resultBuilder);
                } else {
                    CompleteResultBuilderCollectionStandard resultBuilderCollection = this.createSuffixedResultBuilder(collectionReturn, suffix, this.alias2Suffix.get(collectionReturn.getTableAlias()));
                    resultSetMapping.addResultBuilder(resultBuilderCollection);
                    this.alias2Return.put(collectionReturn.getTableAlias(), resultBuilderCollection);
                }
            } else {
                resultSetMapping.addResultBuilder((ResultBuilder)resultBuilder);
            }
        });
        this.resultSetMapping.visitLegacyFetchBuilders(fetchBuilder -> this.applyFetchBuilder(resultSetMapping, (DynamicFetchBuilderLegacy)fetchBuilder, visited));
        return resultSetMapping;
    }

    private void applyFetchBuilder(ResultSetMappingImpl resultSetMapping, DynamicFetchBuilderLegacy fetchBuilder, Set<String> visited) {
        if (!visited.add(fetchBuilder.getTableAlias())) {
            return;
        }
        String suffix = this.alias2Suffix.get(fetchBuilder.getTableAlias());
        if (suffix == null) {
            resultSetMapping.addLegacyFetchBuilder(fetchBuilder);
        } else {
            List<String> columnNames;
            if (!visited.contains(fetchBuilder.getOwnerAlias())) {
                this.applyFetchBuilder(resultSetMapping, (DynamicFetchBuilderLegacy)this.alias2Return.get(fetchBuilder.getOwnerAlias()), visited);
            }
            DynamicResultBuilderEntityStandard ownerBuilder = (DynamicResultBuilderEntityStandard)this.alias2Return.get(fetchBuilder.getOwnerAlias());
            DynamicResultBuilderEntityStandard resultBuilderEntity = this.createSuffixedResultBuilder(this.alias2Persister.get(fetchBuilder.getTableAlias()).findContainingEntityMapping(), fetchBuilder.getTableAlias(), suffix, this.determineNavigablePath(fetchBuilder));
            SQLLoadable loadable = (SQLLoadable)this.alias2Persister.get(fetchBuilder.getOwnerAlias());
            String[] columnAliases = loadable.getSubclassPropertyColumnAliases(fetchBuilder.getFetchableName(), this.alias2Suffix.get(fetchBuilder.getOwnerAlias()));
            if (columnAliases.length == 0) {
                CollectionPersister collectionPersister = this.alias2CollectionPersister.get(fetchBuilder.getTableAlias());
                if (collectionPersister == null) {
                    columnNames = Collections.emptyList();
                } else {
                    String collectionSuffix = this.alias2CollectionSuffix.get(fetchBuilder.getTableAlias());
                    String[] keyColumnAliases = collectionPersister.getKeyColumnAliases(collectionSuffix);
                    columnNames = Arrays.asList(keyColumnAliases);
                    if (collectionPersister.hasIndex()) {
                        resultBuilderEntity.addProperty("{key}", collectionPersister.getIndexColumnAliases(collectionSuffix));
                    }
                }
            } else {
                columnNames = Arrays.asList(columnAliases);
            }
            ownerBuilder.addFetchBuilder(fetchBuilder.getFetchableName(), new DynamicFetchBuilderLegacy(fetchBuilder.getTableAlias(), fetchBuilder.getOwnerAlias(), fetchBuilder.getFetchableName(), columnNames, Collections.emptyMap(), resultBuilderEntity));
            this.alias2Return.put(fetchBuilder.getTableAlias(), resultBuilderEntity);
        }
    }

    private NavigablePath determineNavigablePath(DynamicFetchBuilderLegacy fetchBuilder) {
        NativeQuery.ResultNode ownerResult = this.alias2Return.get(fetchBuilder.getOwnerAlias());
        if (ownerResult instanceof NativeQuery.RootReturn) {
            return ((NativeQuery.RootReturn)ownerResult).getNavigablePath().append(fetchBuilder.getFetchableName());
        }
        return this.determineNavigablePath((DynamicFetchBuilderLegacy)ownerResult).append(fetchBuilder.getFetchableName());
    }

    private DynamicResultBuilderEntityStandard createSuffixedResultBuilder(NativeQuery.RootReturn rootReturn, String suffix) {
        return this.createSuffixedResultBuilder(rootReturn.getEntityMapping(), rootReturn.getTableAlias(), suffix, new NavigablePath(rootReturn.getEntityMapping().getEntityName()));
    }

    private DynamicResultBuilderEntityStandard createSuffixedResultBuilder(EntityMappingType entityMapping, String tableAlias, String suffix, NavigablePath navigablePath) {
        SQLLoadable loadable = (SQLLoadable)entityMapping.getEntityPersister();
        DynamicResultBuilderEntityStandard resultBuilderEntity = new DynamicResultBuilderEntityStandard(entityMapping, tableAlias, navigablePath);
        String[] identifierAliases = loadable.getIdentifierAliases(suffix);
        resultBuilderEntity.addIdColumnAliases(identifierAliases);
        resultBuilderEntity.setDiscriminatorAlias(loadable.getDiscriminatorAlias(suffix));
        if (loadable.hasIdentifierProperty()) {
            resultBuilderEntity.addProperty(loadable.getIdentifierPropertyName(), identifierAliases);
        }
        for (String propertyName : loadable.getPropertyNames()) {
            String[] columnAliases = loadable.getSubclassPropertyColumnAliases(propertyName, suffix);
            if (columnAliases.length == 0) {
                Type propertyType = loadable.getPropertyType(propertyName);
                if (!(propertyType instanceof CollectionType)) continue;
                CollectionType collectionType = (CollectionType)propertyType;
                String[] keyColumnAliases = collectionType.useLHSPrimaryKey() ? identifierAliases : loadable.getSubclassPropertyColumnAliases(collectionType.getLHSPropertyName(), suffix);
                resultBuilderEntity.addProperty(propertyName, keyColumnAliases);
                continue;
            }
            resultBuilderEntity.addProperty(propertyName, columnAliases);
        }
        return resultBuilderEntity;
    }

    private CompleteResultBuilderCollectionStandard createSuffixedResultBuilder(NativeQuery.CollectionReturn collectionReturn, String suffix, String entitySuffix) {
        String[] elementColumnAliases;
        CollectionPersister collectionPersister = collectionReturn.getPluralAttribute().getCollectionDescriptor();
        if (collectionPersister.getElementType().isEntityType()) {
            Loadable elementPersister = (Loadable)((QueryableCollection)collectionPersister).getElementPersister();
            String[] propertyNames = elementPersister.getPropertyNames();
            String[] identifierAliases = elementPersister.getIdentifierAliases(entitySuffix);
            String discriminatorAlias = elementPersister.getDiscriminatorAlias(entitySuffix);
            ArrayList<String> aliases = new ArrayList<String>(propertyNames.length + identifierAliases.length + (discriminatorAlias == null ? 0 : 1));
            Collections.addAll(aliases, identifierAliases);
            if (discriminatorAlias != null) {
                aliases.add(discriminatorAlias);
            }
            for (int i = 0; i < propertyNames.length; ++i) {
                Collections.addAll(aliases, elementPersister.getPropertyAliases(entitySuffix, i));
            }
            elementColumnAliases = ArrayHelper.toStringArray(aliases);
        } else {
            elementColumnAliases = collectionPersister.getElementColumnAliases(suffix);
        }
        return new CompleteResultBuilderCollectionStandard(collectionReturn.getTableAlias(), collectionReturn.getNavigablePath(), collectionReturn.getPluralAttribute(), collectionPersister.getKeyColumnAliases(suffix), collectionPersister.hasIndex() ? collectionPersister.getIndexColumnAliases(suffix) : null, elementColumnAliases);
    }

    private SQLLoadable getSQLLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof SQLLoadable)) {
            throw new MappingException("class persister is not SQLLoadable: " + entityName);
        }
        return (SQLLoadable)persister;
    }

    private String generateEntitySuffix() {
        return AliasConstantsHelper.get(this.entitySuffixSeed++);
    }

    private String generateCollectionSuffix() {
        return this.collectionSuffixSeed++ + "__";
    }

    private void processReturn(NativeQuery.ResultNode rtn) {
        if (rtn instanceof NativeQuery.RootReturn) {
            this.processRootReturn((NativeQuery.RootReturn)rtn);
        } else if (rtn instanceof NativeQuery.FetchReturn) {
            this.processFetchReturn((NativeQuery.FetchReturn)rtn);
        } else if (rtn instanceof NativeQuery.InstantiationResultNode) {
            this.processConstructorReturn((NativeQuery.InstantiationResultNode)rtn);
        } else if (rtn instanceof NativeQuery.ReturnProperty) {
            this.processScalarReturn((NativeQuery.ReturnProperty)rtn);
        } else if (!(rtn instanceof NativeQuery.ReturnableResultNode)) {
            throw new IllegalStateException("Unrecognized NativeSQLQueryReturn concrete type encountered : " + rtn);
        }
    }

    private void processConstructorReturn(NativeQuery.InstantiationResultNode<?> rtn) {
    }

    private void processScalarReturn(NativeQuery.ReturnProperty typeReturn) {
    }

    private void processRootReturn(NativeQuery.RootReturn rootReturn) {
        if (this.alias2Persister.containsKey(rootReturn.getTableAlias())) {
            return;
        }
        SQLLoadable persister = (SQLLoadable)rootReturn.getEntityMapping().getEntityPersister();
        Map<String, String[]> propertyResultsMap = Collections.emptyMap();
        this.addPersister(rootReturn.getTableAlias(), propertyResultsMap, persister);
    }

    private void addPersister(String alias, Map<String, String[]> propertyResult, SQLLoadable persister) {
        this.alias2Persister.put(alias, persister);
        String suffix = this.generateEntitySuffix();
        LOG.tracev("Mapping alias [{0}] to entity-suffix [{1}]", alias, suffix);
        this.alias2Suffix.put(alias, suffix);
        this.entityPropertyResultMaps.put(alias, propertyResult);
    }

    private void addCollection(String role, String alias, Map<String, String[]> propertyResults) {
        SQLLoadableCollection collectionPersister = (SQLLoadableCollection)this.factory.getCollectionPersister(role);
        this.alias2CollectionPersister.put(alias, collectionPersister);
        String suffix = this.generateCollectionSuffix();
        LOG.tracev("Mapping alias [{0}] to collection-suffix [{1}]", alias, suffix);
        this.alias2CollectionSuffix.put(alias, suffix);
        this.collectionPropertyResultMaps.put(alias, propertyResults);
        if (collectionPersister.isOneToMany() || collectionPersister.isManyToMany()) {
            SQLLoadable persister = (SQLLoadable)collectionPersister.getElementPersister();
            this.addPersister(alias, this.filter(propertyResults), persister);
        }
    }

    private Map<String, String[]> filter(Map<String, String[]> propertyResults) {
        HashMap<String, String[]> result = new HashMap<String, String[]>(propertyResults.size());
        String keyPrefix = "element.";
        for (Map.Entry<String, String[]> element : propertyResults.entrySet()) {
            String path = element.getKey();
            if (!path.startsWith("element.")) continue;
            result.put(path.substring("element.".length()), element.getValue());
        }
        return result;
    }

    private void processFetchReturn(NativeQuery.FetchReturn fetchReturn) {
        SQLLoadable ownerPersister;
        Type returnType;
        String alias = fetchReturn.getTableAlias();
        if (this.alias2Persister.containsKey(alias) || this.alias2CollectionPersister.containsKey(alias)) {
            return;
        }
        String ownerAlias = fetchReturn.getOwnerAlias();
        if (!this.alias2Return.containsKey(ownerAlias)) {
            throw new HibernateException("Owner alias [" + ownerAlias + "] is unknown for alias [" + alias + "]");
        }
        if (!this.alias2Persister.containsKey(ownerAlias)) {
            this.processReturn(this.alias2Return.get(ownerAlias));
        }
        if ((returnType = (ownerPersister = (SQLLoadable)this.alias2Persister.get(ownerAlias)).getPropertyType(fetchReturn.getFetchableName())).isCollectionType()) {
            String role = ownerPersister.getEntityName() + '.' + fetchReturn.getFetchableName();
            Map<String, String[]> propertyResultsMap = Collections.emptyMap();
            this.addCollection(role, alias, propertyResultsMap);
        } else if (returnType.isEntityType()) {
            EntityType eType = (EntityType)returnType;
            String returnEntityName = eType.getAssociatedEntityName();
            SQLLoadable persister = this.getSQLLoadable(returnEntityName);
            Map<String, String[]> propertyResultsMap = Collections.emptyMap();
            this.addPersister(alias, propertyResultsMap, persister);
        }
    }

    @Override
    public boolean isEntityAlias(String alias) {
        return this.getEntityPersister(alias) != null;
    }

    @Override
    public boolean isCollectionAlias(String alias) {
        return this.getCollectionPersister(alias) != null;
    }

    @Override
    public SQLLoadable getEntityPersister(String alias) {
        return (SQLLoadable)this.alias2Persister.get(alias);
    }

    @Override
    public SQLLoadableCollection getCollectionPersister(String alias) {
        return (SQLLoadableCollection)this.alias2CollectionPersister.get(alias);
    }

    @Override
    public String getEntitySuffix(String alias) {
        return this.alias2Suffix.get(alias);
    }

    @Override
    public String getCollectionSuffix(String alias) {
        return this.alias2CollectionSuffix.get(alias);
    }

    public String getOwnerAlias(String alias) {
        return this.alias2OwnerAlias.get(alias);
    }

    @Override
    public Map<String, String[]> getPropertyResultsMap(String alias) {
        return this.internalGetPropertyResultsMap(alias);
    }

    public String[] collectQuerySpaces() {
        HashSet<String> spaces = new HashSet<String>();
        this.collectQuerySpaces(spaces);
        return spaces.toArray(new String[spaces.size()]);
    }

    public void collectQuerySpaces(Collection<String> spaces) {
        for (EntityPersister entityPersister : this.alias2Persister.values()) {
            Collections.addAll(spaces, (String[])entityPersister.getQuerySpaces());
        }
        for (CollectionPersister collectionPersister : this.alias2CollectionPersister.values()) {
            Type elementType = collectionPersister.getElementType();
            if (!elementType.isEntityType() || elementType.isAnyType()) continue;
            Joinable joinable = ((EntityType)elementType).getAssociatedJoinable(this.factory);
            Collections.addAll(spaces, (String[])((EntityPersister)((Object)joinable)).getQuerySpaces());
        }
    }
}

