/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.type.spi.TypeConfiguration;

public class MultipatternSqmFunctionDescriptor
extends AbstractSqmFunctionDescriptor {
    private SqmFunctionDescriptor[] functions;
    private String argumentListSignature;

    private static int first(SqmFunctionDescriptor[] functions) {
        for (int i = 0; i < functions.length; ++i) {
            if (functions[i] == null) continue;
            return i;
        }
        throw new IllegalArgumentException("no functions");
    }

    private static int last(SqmFunctionDescriptor[] functions) {
        return functions.length - 1;
    }

    public MultipatternSqmFunctionDescriptor(String name, SqmFunctionDescriptor[] functions, FunctionReturnTypeResolver type) {
        super(name, StandardArgumentsValidators.between(MultipatternSqmFunctionDescriptor.first(functions), MultipatternSqmFunctionDescriptor.last(functions)), type);
        this.functions = functions;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return this.functions[arguments.size()].generateSqmExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
    }

    @Override
    public String getArgumentListSignature() {
        return this.argumentListSignature == null ? super.getArgumentListSignature() : this.argumentListSignature;
    }

    public void setArgumentListSignature(String argumentListSignature) {
        this.argumentListSignature = argumentListSignature;
    }
}

