/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Tuple;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.query.spi.EntityGraphQueryHint;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.query.ImmutableEntityUpdateQueryHandlingMode;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.hql.internal.QuerySplitter;
import org.hibernate.query.hql.spi.HqlQueryImplementor;
import org.hibernate.query.hql.spi.NamedHqlQueryMemento;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.spi.AbstractQuery;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.AggregatedSelectQueryPlanImpl;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.MultiTableDeleteQueryPlan;
import org.hibernate.query.sqm.internal.MultiTableUpdateQueryPlan;
import org.hibernate.query.sqm.internal.SimpleDeleteQueryPlan;
import org.hibernate.query.sqm.internal.SimpleInsertQueryPlan;
import org.hibernate.query.sqm.internal.SimpleUpdateQueryPlan;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class QuerySqmImpl<R>
extends AbstractQuery<R>
implements HqlQueryImplementor<R>,
ExecutionContext {
    public static final String CRITERIA_HQL_STRING = "<criteria>";
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(QuerySqmImpl.class);
    private final String hqlString;
    private final SqmStatement<R> sqmStatement;
    private final Class<R> resultType;
    private final ParameterMetadataImplementor parameterMetadata;
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindingsImpl parameterBindings;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();
    private Callback callback;

    public QuerySqmImpl(NamedHqlQueryMemento memento, Class<R> resultType, SharedSessionContractImplementor producer) {
        super(producer);
        this.hqlString = memento.getHqlString();
        SessionFactoryImplementor factory = producer.getFactory();
        QueryEngine queryEngine = factory.getQueryEngine();
        QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
        HqlInterpretation hqlInterpretation = interpretationCache.resolveHqlInterpretation(this.hqlString, s -> queryEngine.getHqlTranslator().translate(this.hqlString));
        this.sqmStatement = hqlInterpretation.getSqmStatement();
        if (resultType != null) {
            if (this.sqmStatement instanceof SqmDmlStatement) {
                throw new IllegalArgumentException("Non-select queries cannot be typed");
            }
        } else if (this.sqmStatement instanceof SqmUpdateStatement) {
            this.verifyImmutableEntityUpdate(this.hqlString, (SqmUpdateStatement)this.sqmStatement, producer.getFactory());
        }
        this.resultType = resultType;
        this.domainParameterXref = hqlInterpretation.getDomainParameterXref();
        this.parameterMetadata = hqlInterpretation.getParameterMetadata();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, producer.getFactory(), producer.isQueryParametersValidationEnabled());
        this.applyOptions(memento);
    }

    protected void applyOptions(NamedHqlQueryMemento memento) {
        super.applyOptions(memento);
        if (memento.getFirstResult() != null) {
            this.setFirstResult(memento.getFirstResult());
        }
        if (memento.getMaxResults() != null) {
            this.setMaxResults(memento.getMaxResults());
        }
        if (memento.getParameterTypes() != null) {
            for (Map.Entry<String, String> entry : memento.getParameterTypes().entrySet()) {
                QueryParameter parameter = this.parameterMetadata.getQueryParameter(entry.getKey());
                BasicType type = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(entry.getValue());
                parameter.applyAnticipatedType(type);
            }
        }
    }

    public QuerySqmImpl(String hqlString, HqlInterpretation hqlInterpretation, Class<R> resultType, SharedSessionContractImplementor producer) {
        super(producer);
        this.hqlString = hqlString;
        this.resultType = resultType;
        this.sqmStatement = hqlInterpretation.getSqmStatement();
        if (resultType != null) {
            SqmUtil.verifyIsSelectStatement(this.sqmStatement, hqlString);
            this.visitQueryReturnType((SqmQueryPart<R>)((SqmSelectStatement)this.sqmStatement).getQueryPart(), resultType, producer.getFactory());
        } else if (this.sqmStatement instanceof SqmUpdateStatement) {
            this.verifyImmutableEntityUpdate(hqlString, (SqmUpdateStatement)this.sqmStatement, producer.getFactory());
        }
        this.parameterMetadata = hqlInterpretation.getParameterMetadata();
        this.domainParameterXref = hqlInterpretation.getDomainParameterXref();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, producer.getFactory(), producer.isQueryParametersValidationEnabled());
    }

    public QuerySqmImpl(SqmStatement<R> sqmStatement, Class<R> resultType, SharedSessionContractImplementor producer) {
        super(producer);
        if (resultType != null) {
            SqmUtil.verifyIsSelectStatement(sqmStatement, null);
            JpaQueryPart queryPart = ((SqmSelectStatement)sqmStatement).getQueryPart();
            ((SqmQueryPart)queryPart).validateQueryGroupFetchStructure();
            this.visitQueryReturnType((SqmQueryPart<R>)queryPart, resultType, producer.getFactory());
        } else if (sqmStatement instanceof SqmUpdateStatement) {
            SqmUpdateStatement updateStatement = (SqmUpdateStatement)sqmStatement;
            this.verifyImmutableEntityUpdate(CRITERIA_HQL_STRING, updateStatement, producer.getFactory());
            if (updateStatement.getSetClause() == null || updateStatement.getSetClause().getAssignments().isEmpty()) {
                throw new IllegalArgumentException("No assignments specified as part of UPDATE criteria");
            }
        }
        this.hqlString = CRITERIA_HQL_STRING;
        this.sqmStatement = sqmStatement;
        this.resultType = resultType;
        this.domainParameterXref = DomainParameterXref.from(sqmStatement);
        this.parameterMetadata = !this.domainParameterXref.hasParameters() ? ParameterMetadataImpl.EMPTY : new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters());
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, producer.getFactory(), producer.isQueryParametersValidationEnabled());
        for (SqmParameter<?> sqmParameter : this.domainParameterXref.getParameterResolutions().getSqmParameters()) {
            JpaCriteriaParameter jpaCriteriaParameter;
            Object value;
            if (!(sqmParameter instanceof SqmJpaCriteriaParameterWrapper) || (value = (jpaCriteriaParameter = ((SqmJpaCriteriaParameterWrapper)sqmParameter).getJpaCriteriaParameter()).getValue()) == null && jpaCriteriaParameter.getNodeType() != null) continue;
            this.getQueryParameterBindings().getBinding(jpaCriteriaParameter).setBindValue(value, jpaCriteriaParameter.getAnticipatedType());
        }
    }

    private void visitQueryReturnType(SqmQueryPart<R> queryPart, Class<R> resultType, SessionFactoryImplementor factory) {
        if (queryPart instanceof SqmQuerySpec) {
            SqmQuerySpec sqmQuerySpec = (SqmQuerySpec)queryPart;
            List<SqmSelection<?>> sqmSelections = sqmQuerySpec.getSelectClause().getSelections();
            if (sqmSelections == null || sqmSelections.isEmpty()) {
                List<SqmRoot<?>> sqmRoots = sqmQuerySpec.getFromClause().getRoots();
                if (sqmRoots == null || sqmRoots.isEmpty()) {
                    throw new IllegalArgumentException("Criteria did not define any query roots");
                }
                if (sqmRoots.size() == 1) {
                    SqmRoot<?> sqmRoot = sqmRoots.get(0);
                    sqmQuerySpec.getSelectClause().add(sqmRoot, (String)null);
                } else {
                    throw new IllegalArgumentException();
                }
            }
            if (resultType != null) {
                QuerySqmImpl.checkQueryReturnType(sqmQuerySpec, resultType, factory);
            }
        } else {
            SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
            for (SqmQueryPart sqmQueryPart : queryGroup.getQueryParts()) {
                this.visitQueryReturnType(sqmQueryPart, resultType, factory);
            }
        }
    }

    private static <T> void checkQueryReturnType(SqmQuerySpec<T> querySpec, Class<T> resultClass, SessionFactoryImplementor sessionFactory) {
        if (resultClass == null) {
            return;
        }
        List<SqmSelection<?>> selections = querySpec.getSelectClause().getSelections();
        if (!resultClass.isArray() && !Tuple.class.isAssignableFrom(resultClass)) {
            SqmParameter sqmParameter;
            if (selections.size() != 1) {
                String errorMessage = "Query result-type error - multiple selections: use Tuple or array";
                if (sessionFactory.getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled()) {
                    throw new IllegalArgumentException("Query result-type error - multiple selections: use Tuple or array");
                }
                throw new QueryTypeMismatchException("Query result-type error - multiple selections: use Tuple or array");
            }
            SqmSelection<?> sqmSelection = selections.get(0);
            if (sqmSelection.getSelectableNode() instanceof SqmParameter && ((sqmParameter = (SqmParameter)sqmSelection.getSelectableNode()).getNodeType() == null || sqmParameter.getNodeType().getExpressableJavaTypeDescriptor() == null)) {
                return;
            }
            QuerySqmImpl.verifyResultType(resultClass, sqmSelection.getNodeType(), sessionFactory);
        }
    }

    private static <T> void verifyResultType(Class<T> resultClass, SqmExpressable<?> sqmExpressable, SessionFactoryImplementor sessionFactory) {
        assert (sqmExpressable != null);
        assert (sqmExpressable.getExpressableJavaTypeDescriptor() != null);
        Class<?> javaTypeClass = sqmExpressable.getExpressableJavaTypeDescriptor().getJavaTypeClass();
        if (!resultClass.isAssignableFrom(javaTypeClass)) {
            if (javaTypeClass == Date.class) {
                DomainType<?> domainType;
                JdbcType jdbcType = null;
                if (sqmExpressable instanceof BasicDomainType) {
                    jdbcType = ((BasicDomainType)sqmExpressable).getJdbcTypeDescriptor();
                } else if (sqmExpressable instanceof SqmPathSource && (domainType = ((SqmPathSource)sqmExpressable).getSqmPathType()) instanceof BasicDomainType) {
                    jdbcType = ((BasicDomainType)domainType).getJdbcTypeDescriptor();
                }
                if (jdbcType != null) {
                    switch (jdbcType.getJdbcTypeCode()) {
                        case 91: {
                            if (!resultClass.isAssignableFrom(java.sql.Date.class)) break;
                            return;
                        }
                        case 92: {
                            if (!resultClass.isAssignableFrom(Time.class)) break;
                            return;
                        }
                        case 93: {
                            if (!resultClass.isAssignableFrom(Timestamp.class)) break;
                            return;
                        }
                    }
                }
            }
            String errorMessage = String.format("Specified result type [%s] did not match Query selection type [%s] - multiple selections: use Tuple or array", resultClass.getName(), sqmExpressable.getExpressableJavaTypeDescriptor().getJavaType().getTypeName());
            if (sessionFactory.getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled()) {
                throw new IllegalArgumentException(errorMessage);
            }
            throw new QueryTypeMismatchException(errorMessage);
        }
    }

    private void verifyImmutableEntityUpdate(String hqlString, SqmUpdateStatement<R> sqmStatement, SessionFactoryImplementor factory) {
        EntityPersister entityDescriptor = factory.getDomainModel().getEntityDescriptor(((SqmRoot)sqmStatement.getTarget()).getEntityName());
        if (entityDescriptor.isMutable()) {
            return;
        }
        ImmutableEntityUpdateQueryHandlingMode immutableEntityUpdateQueryHandlingMode = factory.getSessionFactoryOptions().getImmutableEntityUpdateQueryHandlingMode();
        String querySpaces = Arrays.toString(entityDescriptor.getQuerySpaces());
        switch (immutableEntityUpdateQueryHandlingMode) {
            case WARNING: {
                LOG.immutableEntityUpdateQuery(hqlString, querySpaces);
                break;
            }
            case EXCEPTION: {
                throw new HibernateException("The query: [" + hqlString + "] attempts to update an immutable entity: " + querySpaces);
            }
            default: {
                throw new UnsupportedOperationException("The " + (Object)((Object)immutableEntityUpdateQueryHandlingMode) + " is not supported!");
            }
        }
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.getSession().getFactory();
    }

    @Override
    public QueryParameterBindings getParameterBindings() {
        return this.parameterBindings;
    }

    protected Boolean isSelectQuery() {
        return this.sqmStatement instanceof SqmSelectStatement;
    }

    @Override
    public String getQueryString() {
        return this.hqlString;
    }

    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    @Override
    public HqlQueryImplementor<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        this.queryOptions.applyGraph((RootGraphImplementor)graph, semantic);
        return this;
    }

    @Override
    protected void applyEntityGraphQueryHint(String hintName, RootGraphImplementor entityGraph) {
        GraphSemantic graphSemantic = GraphSemantic.fromJpaHintName(hintName);
        this.applyGraph((RootGraph)entityGraph, graphSemantic);
    }

    @Override
    public SqmStatement<R> getSqmStatement() {
        return this.sqmStatement;
    }

    public Class<R> getResultType() {
        return this.resultType;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        this.getSession().checkOpen(false);
        HashSet parameters = new HashSet();
        this.parameterMetadata.collectAllParameters(parameters::add);
        return parameters;
    }

    @Override
    protected boolean resolveJdbcParameterTypeIfNecessary() {
        return false;
    }

    @Override
    public LockModeType getLockMode() {
        if (!this.isSelectQuery().booleanValue()) {
            throw new IllegalStateException("Illegal attempt to access lock-mode for non-select query");
        }
        return super.getLockMode();
    }

    @Override
    public HqlQueryImplementor<R> setLockMode(LockModeType lockModeType) {
        if (!LockModeType.NONE.equals((Object)lockModeType) && !this.isSelectQuery().booleanValue()) {
            throw new IllegalStateException("Illegal attempt to access lock-mode for non-select query");
        }
        return (HqlQueryImplementor)super.setLockMode(lockModeType);
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this)) {
            return (T)this;
        }
        if (cls.isInstance(this.parameterMetadata)) {
            return (T)this.parameterMetadata;
        }
        if (cls.isInstance(this.parameterBindings)) {
            return (T)this.parameterBindings;
        }
        if (cls.isInstance(this.sqmStatement)) {
            return (T)this.sqmStatement;
        }
        if (cls.isInstance(this.queryOptions)) {
            return (T)this.queryOptions;
        }
        if (cls.isInstance(this.queryOptions.getAppliedGraph())) {
            return (T)this.queryOptions.getAppliedGraph();
        }
        if (EntityGraphQueryHint.class.isAssignableFrom(cls)) {
            return (T)new EntityGraphQueryHint(this.queryOptions.getAppliedGraph());
        }
        throw new PersistenceException("Unrecognized unwrap type [" + cls.getName() + "]");
    }

    @Override
    protected boolean applyNativeQueryLockMode(Object value) {
        throw new IllegalStateException("Illegal attempt to set lock mode on non-native query via hint; use Query#setLockMode instead");
    }

    @Override
    protected boolean applySynchronizeSpacesHint(Object value) {
        throw new IllegalStateException("Illegal attempt to set synchronized spaces on non-native query via hint");
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        super.collectHints(hints);
        if (this.queryOptions.getAppliedGraph() != null && this.queryOptions.getAppliedGraph().getSemantic() != null) {
            hints.put(this.queryOptions.getAppliedGraph().getSemantic().getJpaHintName(), this.queryOptions.getAppliedGraph().getGraph());
        }
    }

    @Override
    protected List<R> doList() {
        ExecutionContext executionContextToUse;
        boolean needsDistincting;
        SqmUtil.verifyIsSelectStatement(this.getSqmStatement(), this.hqlString);
        SqmSelectStatement selectStatement = (SqmSelectStatement)this.getSqmStatement();
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getLockOptions().findGreatestLockMode()));
        boolean containsCollectionFetches = selectStatement.containsCollectionFetches();
        boolean hasLimit = this.queryOptions.hasLimit();
        boolean bl = needsDistincting = containsCollectionFetches && (selectStatement.usesDistinct() || this.queryOptions.getGraph() != null || hasLimit);
        if (hasLimit && containsCollectionFetches) {
            boolean fail = this.getSessionFactory().getSessionFactoryOptions().isFailOnPaginationOverCollectionFetchEnabled();
            if (fail) {
                throw new HibernateException("firstResult/maxResults specified with collection fetch. In memory pagination was about to be applied. Failing because 'Fail on pagination over collection fetch' is enabled.");
            }
            LOG.firstOrMaxResultsSpecifiedWithCollectionFetch();
            executionContextToUse = SqlOmittingQueryOptions.omitSqlQueryOptions(this, true, false);
        } else {
            executionContextToUse = this;
        }
        List<R> list = this.resolveSelectQueryPlan().performList(executionContextToUse);
        if (needsDistincting) {
            int includedCount = -1;
            int first = !hasLimit || this.queryOptions.getLimit().getFirstRow() == null ? 0 : this.queryOptions.getLimit().getFirstRow();
            int max = !hasLimit || this.queryOptions.getLimit().getMaxRows() == null ? -1 : this.queryOptions.getLimit().getMaxRows();
            ArrayList<R> tmp = new ArrayList<R>(list.size());
            IdentitySet<R> distinction = new IdentitySet<R>(list.size());
            for (R result : list) {
                if (!distinction.add(result) || ++includedCount < first) continue;
                tmp.add(result);
                if (max < 0 || includedCount - first < max - 1) continue;
                break;
            }
            return tmp;
        }
        return list;
    }

    private boolean requiresTxn(LockMode lockMode) {
        return lockMode != null && lockMode.greaterThan(LockMode.READ);
    }

    private SelectQueryPlan<R> resolveSelectQueryPlan() {
        SqmInterpretationsKey cacheKey = SqmInterpretationsKey.generateFrom(this);
        if (cacheKey != null) {
            return this.getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan(cacheKey, this::buildSelectQueryPlan);
        }
        return this.buildSelectQueryPlan();
    }

    private SelectQueryPlan<R> buildSelectQueryPlan() {
        SqmSelectStatement<R>[] concreteSqmStatements = QuerySplitter.split((SqmSelectStatement)this.getSqmStatement(), this.getSessionFactory());
        if (concreteSqmStatements.length > 1) {
            return this.buildAggregatedSelectQueryPlan(concreteSqmStatements);
        }
        return this.buildConcreteSelectQueryPlan(concreteSqmStatements[0], this.getResultType(), this.getQueryOptions());
    }

    private SelectQueryPlan<R> buildAggregatedSelectQueryPlan(SqmSelectStatement<R>[] concreteSqmStatements) {
        SelectQueryPlan[] aggregatedQueryPlans = new SelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteSelectQueryPlan(concreteSqmStatements[i], this.getResultType(), this.getQueryOptions());
        }
        return new AggregatedSelectQueryPlanImpl(aggregatedQueryPlans);
    }

    private SelectQueryPlan<R> buildConcreteSelectQueryPlan(SqmSelectStatement<R> concreteSqmStatement, Class<R> resultType, QueryOptions queryOptions) {
        return new ConcreteSqmSelectQueryPlan<R>(concreteSqmStatement, this.domainParameterXref, resultType, queryOptions);
    }

    @Override
    public ScrollableResultsImplementor<R> scroll(ScrollMode scrollMode) {
        SqmUtil.verifyIsSelectStatement(this.getSqmStatement(), this.hqlString);
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getLockOptions().findGreatestLockMode()));
        return this.resolveSelectQueryPlan().performScroll(scrollMode, this);
    }

    @Override
    protected int doExecuteUpdate() {
        SqmUtil.verifyIsNonSelectStatement(this.getSqmStatement(), this.hqlString);
        this.getSession().prepareForQueryExecution(true);
        return this.resolveNonSelectQueryPlan().executeUpdate(this);
    }

    private NonSelectQueryPlan resolveNonSelectQueryPlan() {
        NonSelectQueryPlan queryPlan = null;
        QueryInterpretationCache.Key cacheKey = SqmInterpretationsKey.generateNonSelectKey(this);
        if (cacheKey != null) {
            queryPlan = this.getSession().getFactory().getQueryEngine().getInterpretationCache().getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = this.buildNonSelectQueryPlan();
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getInterpretationCache().cacheNonSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    private NonSelectQueryPlan buildNonSelectQueryPlan() {
        if (this.getSqmStatement() instanceof SqmDeleteStatement) {
            return this.buildDeleteQueryPlan();
        }
        if (this.getSqmStatement() instanceof SqmUpdateStatement) {
            return this.buildUpdateQueryPlan();
        }
        if (this.getSqmStatement() instanceof SqmInsertStatement) {
            return this.buildInsertQueryPlan();
        }
        throw new NotYetImplementedException("Query#executeUpdate for Statements of type [" + this.getSqmStatement() + "not yet supported");
    }

    private NonSelectQueryPlan buildDeleteQueryPlan() {
        SqmDeleteStatement sqmDelete = (SqmDeleteStatement)this.getSqmStatement();
        String entityNameToDelete = ((SqmRoot)sqmDelete.getTarget()).getReferencedPathSource().getHibernateEntityName();
        EntityPersister entityDescriptor = this.getSessionFactory().getDomainModel().findEntityDescriptor(entityNameToDelete);
        SqmMultiTableMutationStrategy multiTableStrategy = entityDescriptor.getSqmMultiTableMutationStrategy();
        if (multiTableStrategy == null) {
            return new SimpleDeleteQueryPlan(entityDescriptor, sqmDelete, this.domainParameterXref);
        }
        return new MultiTableDeleteQueryPlan(sqmDelete, this.domainParameterXref, multiTableStrategy);
    }

    private NonSelectQueryPlan buildUpdateQueryPlan() {
        SqmUpdateStatement sqmUpdate = (SqmUpdateStatement)this.getSqmStatement();
        String entityNameToUpdate = ((SqmRoot)sqmUpdate.getTarget()).getReferencedPathSource().getHibernateEntityName();
        EntityPersister entityDescriptor = this.getSessionFactory().getDomainModel().findEntityDescriptor(entityNameToUpdate);
        SqmMultiTableMutationStrategy multiTableStrategy = entityDescriptor.getSqmMultiTableMutationStrategy();
        if (multiTableStrategy == null) {
            return new SimpleUpdateQueryPlan(sqmUpdate, this.domainParameterXref);
        }
        return new MultiTableUpdateQueryPlan(sqmUpdate, this.domainParameterXref, multiTableStrategy);
    }

    private NonSelectQueryPlan buildInsertQueryPlan() {
        SqmInsertStatement sqmInsert = (SqmInsertStatement)this.getSqmStatement();
        return new SimpleInsertQueryPlan(sqmInsert, this.domainParameterXref);
    }

    @Override
    protected void prepareForExecution() {
        super.prepareForExecution();
        this.callback = null;
    }

    @Override
    public Callback getCallback() {
        if (this.callback == null) {
            this.callback = new CallbackImpl();
        }
        return this.callback;
    }

    @Override
    public void invokeAfterLoadActions(SharedSessionContractImplementor session, Object entity, Loadable persister) {
        if (this.callback != null) {
            this.callback.invokeAfterLoadActions(session, entity, persister);
        }
    }

    @Override
    public String getQueryIdentifier(String sql) {
        if (CRITERIA_HQL_STRING.equals(this.hqlString)) {
            return "[CRITERIA] " + sql;
        }
        return this.hqlString;
    }

    @Override
    public NamedHqlQueryMemento toMemento(String name) {
        return new NamedHqlQueryMementoImpl(name, this.hqlString, this.getFirstResult(), this.getMaxResults(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getHibernateFlushMode(), this.isReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), Collections.emptyMap(), this.getHints());
    }

    @Override
    public boolean hasQueryExecutionToBeAddedToStatistics() {
        return !CRITERIA_HQL_STRING.equals(this.hqlString);
    }
}

