/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import jakarta.persistence.metamodel.Bindable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.FilterHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.jboss.logging.Logger;

public class MatchingIdSelectionHelper {
    private static final Logger log = Logger.getLogger(MatchingIdSelectionHelper.class);

    public static SelectStatement generateMatchingIdSelectStatement(EntityMappingType targetEntityDescriptor, SqmDeleteOrUpdateStatement sqmStatement, boolean queryRoot, Predicate restriction, MultiTableSqmMutationConverter sqmConverter, ExecutionContext executionContext, SessionFactoryImplementor sessionFactory) {
        Bindable entityDomainType = ((SqmRoot)sqmStatement.getTarget()).getModel();
        if (log.isTraceEnabled()) {
            log.tracef("Starting generation of entity-id SQM selection - %s", (Object)entityDomainType.getHibernateEntityName());
        }
        QuerySpec idSelectionQuery = new QuerySpec(queryRoot, 1);
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        idSelectionQuery.getFromClause().addRoot(mutatingTableGroup);
        ArrayList domainResults = new ArrayList();
        targetEntityDescriptor.getIdentifierMapping().forEachSelectable((position, selection) -> {
            TableReference tableReference = mutatingTableGroup.resolveTableReference(mutatingTableGroup.getNavigablePath(), selection.getContainingTableExpression());
            Expression expression = sqmConverter.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference, selection, sessionFactory));
            idSelectionQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(position, position + 1, expression));
            domainResults.add(new BasicResult(position, null, selection.getJdbcMapping().getJavaTypeDescriptor()));
        });
        FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(executionContext.getLoadQueryInfluencers(), (Joinable)((Object)targetEntityDescriptor.getEntityPersister()), mutatingTableGroup);
        if (filterPredicate != null) {
            restriction = SqlAstTreeHelper.combinePredicates(restriction, filterPredicate);
        }
        idSelectionQuery.applyPredicate(restriction);
        return new SelectStatement(idSelectionQuery, domainResults);
    }

    public static QuerySpec generateMatchingIdSelectQuery(EntityMappingType targetEntityDescriptor, SqmDeleteOrUpdateStatement sqmStatement, DomainParameterXref domainParameterXref, Predicate restriction, MultiTableSqmMutationConverter sqmConverter, SessionFactoryImplementor sessionFactory) {
        Bindable entityDomainType = ((SqmRoot)sqmStatement.getTarget()).getModel();
        if (log.isTraceEnabled()) {
            log.tracef("Starting generation of entity-id SQM selection - %s", (Object)entityDomainType.getHibernateEntityName());
        }
        QuerySpec idSelectionQuery = new QuerySpec(true, 1);
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        idSelectionQuery.getFromClause().addRoot(mutatingTableGroup);
        targetEntityDescriptor.getIdentifierMapping().forEachSelectable((position, selection) -> {
            TableReference tableReference = mutatingTableGroup.resolveTableReference(mutatingTableGroup.getNavigablePath(), selection.getContainingTableExpression());
            Expression expression = sqmConverter.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference, selection, sessionFactory));
            idSelectionQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(position, position + 1, expression));
        });
        idSelectionQuery.applyPredicate(restriction);
        return idSelectionQuery;
    }

    public static List<Object> selectMatchingIds(SqmDeleteOrUpdateStatement sqmMutationStatement, DomainParameterXref domainParameterXref, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        EntityPersister entityDescriptor = factory.getDomainModel().getEntityDescriptor(((SqmRoot)sqmMutationStatement.getTarget()).getModel().getHibernateEntityName());
        MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter(entityDescriptor, ((AbstractSqmFrom)((Object)sqmMutationStatement.getTarget())).getExplicitAlias(), domainParameterXref, executionContext.getQueryOptions(), executionContext.getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), factory);
        Map parameterResolutions = domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        Predicate restriction = sqmConverter.visitWhereClause(sqmMutationStatement.getWhereClause(), columnReference -> {}, (sqmParam, mappingType, jdbcParameters) -> parameterResolutions.put(sqmParam, jdbcParameters));
        SelectStatement matchingIdSelection = MatchingIdSelectionHelper.generateMatchingIdSelectStatement(entityDescriptor, sqmMutationStatement, true, restriction, sqmConverter, executionContext, factory);
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslator<JdbcSelect> sqlAstSelectTranslator = jdbcEnvironment.getSqlAstTranslatorFactory().buildSelectTranslator(factory, matchingIdSelection);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmConverter), factory.getDomainModel(), navigablePath -> sqmConverter.getMutatingTableGroup(), sqmConverter.getSqmParameterMappingModelExpressableResolutions()::get, executionContext.getSession());
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions();
        LockMode lockMode = lockOptions.getLockMode();
        lockOptions.setLockMode(LockMode.WRITE);
        if (!jdbcEnvironment.getDialect().supportsOuterJoinForUpdate()) {
            matchingIdSelection.getQuerySpec().getFromClause().visitTableJoins(tableJoin -> {
                if (tableJoin.getJoinType() != SqlAstJoinType.INNER) {
                    lockOptions.setLockMode(lockMode);
                }
            });
        }
        JdbcSelect idSelectJdbcOperation = sqlAstSelectTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        lockOptions.setLockMode(lockMode);
        return jdbcServices.getJdbcSelectExecutor().list(idSelectJdbcOperation, jdbcParameterBindings, SqlOmittingQueryOptions.omitSqlQueryOptions(executionContext, idSelectJdbcOperation), row -> row, ListResultsConsumer.UniqueSemantic.FILTER);
    }
}

