/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Contributable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableColumn;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableSessionUidColumn;

public class IdTable
implements Exportable,
Contributable {
    private final EntityMappingType entityDescriptor;
    private final String qualifiedTableName;
    private IdTableSessionUidColumn sessionUidColumn;
    private final List<IdTableColumn> columns = new ArrayList<IdTableColumn>();
    private final Dialect dialect;

    public IdTable(EntityMappingType entityDescriptor, Function<String, String> idTableNameAdjuster, Dialect dialect) {
        this.entityDescriptor = entityDescriptor;
        this.qualifiedTableName = idTableNameAdjuster.apply(entityDescriptor.getEntityPersister().getSynchronizedQuerySpaces()[0]);
        entityDescriptor.getIdentifierMapping().forEachSelectable((columnIndex, selection) -> this.columns.add(new IdTableColumn(this, selection.getSelectionExpression(), selection.getJdbcMapping(), dialect.getTypeName(selection.getJdbcMapping().getJdbcTypeDescriptor()))));
        this.dialect = dialect;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public List<IdTableColumn> getIdTableColumns() {
        return this.columns;
    }

    public IdTableSessionUidColumn getSessionUidColumn() {
        return this.sessionUidColumn;
    }

    public String getTableExpression() {
        return this.qualifiedTableName;
    }

    public void addColumn(IdTableColumn column) {
        this.columns.add(column);
        if (column instanceof IdTableSessionUidColumn) {
            this.sessionUidColumn = (IdTableSessionUidColumn)column;
        }
    }

    @Override
    public String getContributor() {
        return this.entityDescriptor.getContributor();
    }

    @Override
    public String getExportIdentifier() {
        return this.getQualifiedTableName();
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

