/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.EntityType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaCriteriaBase;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.AbstractSqmDmlStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;

public abstract class AbstractSqmRestrictedDmlStatement<T>
extends AbstractSqmDmlStatement<T>
implements JpaCriteriaBase {
    private SqmWhereClause whereClause;

    public AbstractSqmRestrictedDmlStatement(SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(querySource, nodeBuilder);
    }

    public AbstractSqmRestrictedDmlStatement(SqmRoot<T> target, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(target, querySource, nodeBuilder);
    }

    public Root<T> from(Class<T> entityClass) {
        EntityType entity = this.nodeBuilder().getDomainModel().entity(entityClass);
        SqmRoot root = new SqmRoot(entity, null, false, this.nodeBuilder());
        this.setTarget(root);
        return root;
    }

    public Root<T> from(EntityType<T> entity) {
        SqmRoot root = new SqmRoot((EntityDomainType)entity, null, false, this.nodeBuilder());
        this.setTarget(root);
        return root;
    }

    public Root<T> getRoot() {
        return this.getTarget();
    }

    public SqmWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void applyPredicate(SqmPredicate predicate) {
        if (predicate == null) {
            return;
        }
        if (this.whereClause == null) {
            this.whereClause = new SqmWhereClause(this.nodeBuilder());
        }
        this.whereClause.applyPredicate(predicate);
    }

    public void setWhereClause(SqmWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public JpaPredicate getRestriction() {
        return this.whereClause == null ? null : this.whereClause.getPredicate();
    }

    protected void setWhere(Expression<Boolean> restriction) {
        this.applyPredicate(null);
        this.applyPredicate((SqmPredicate)restriction);
    }

    protected void setWhere(Predicate ... restrictions) {
        this.applyPredicate(null);
        SqmWhereClause whereClause = this.getWhereClause();
        for (Predicate restriction : restrictions) {
            whereClause.applyPredicate((SqmPredicate)restriction);
        }
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        if (this.whereClause != null && this.whereClause.getPredicate() != null) {
            sb.append(" where ");
            this.whereClause.getPredicate().appendHqlString(sb);
        }
    }
}

