/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.cte;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;

public class SqmCteTable
implements Serializable {
    private final String cteName;
    private final List<SqmCteTableColumn> columns;

    public SqmCteTable(String cteName, EntityMappingType entityDescriptor) {
        int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
        ArrayList<SqmCteTableColumn> columns = new ArrayList<SqmCteTableColumn>(numberOfColumns);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        String idName = identifierMapping instanceof SingleAttributeIdentifierMapping ? ((SingleAttributeIdentifierMapping)identifierMapping).getAttributeName() : "id";
        columns.add(new SqmCteTableColumn(this, idName, identifierMapping));
        this.cteName = cteName;
        this.columns = columns;
    }

    public SqmCteTable(String cteName, List<SqmCteTableColumn> columns) {
        this.cteName = cteName;
        this.columns = columns;
    }

    public String getCteName() {
        return this.cteName;
    }

    public List<SqmCteTableColumn> getColumns() {
        return this.columns;
    }

    public void visitColumns(Consumer<SqmCteTableColumn> columnConsumer) {
        for (int i = 0; i < this.columns.size(); ++i) {
            columnConsumer.accept(this.columns.get(i));
        }
    }
}

