/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmJoinable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.type.descriptor.java.JavaType;
import org.jboss.logging.Logger;

public abstract class AbstractSqmAttributeJoin<O, T>
extends AbstractSqmJoin<O, T>
implements SqmAttributeJoin<O, T> {
    private static final Logger log = Logger.getLogger(AbstractSqmAttributeJoin.class);
    private final boolean fetched;
    private SqmPredicate onClausePredicate;

    public AbstractSqmAttributeJoin(SqmFrom<?, O> lhs, SqmJoinable joinedNavigable, String alias, SqmJoinType joinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(SqmCreationHelper.buildSubNavigablePath(lhs, joinedNavigable.getName(), alias), (SqmPathSource)((Object)joinedNavigable), lhs, alias, joinType, nodeBuilder);
        this.fetched = fetched;
    }

    @Override
    public SqmFrom<?, O> getLhs() {
        return (SqmFrom)super.getLhs();
    }

    @Override
    public JavaType<T> getNodeJavaTypeDescriptor() {
        return this.getJavaTypeDescriptor();
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public SqmPredicate getJoinPredicate() {
        return this.onClausePredicate;
    }

    @Override
    public void setJoinPredicate(SqmPredicate predicate) {
        if (log.isTraceEnabled()) {
            log.tracef("Setting join predicate [%s] (was [%s])", (Object)predicate.toString(), (Object)(this.onClausePredicate == null ? "<null>" : this.onClausePredicate.toString()));
        }
        this.onClausePredicate = predicate;
    }

    public void applyRestriction(SqmPredicate restriction) {
        this.onClausePredicate = this.onClausePredicate == null ? restriction : this.nodeBuilder().and(this.onClausePredicate, restriction);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQualifiedAttributeJoin(this);
    }

    @Override
    public PersistentAttribute<? super O, ?> getAttribute() {
        return (PersistentAttribute)((Object)this.getReferencedPathSource());
    }

    @Override
    public SqmAttributeJoin<O, T> on(JpaExpression<Boolean> restriction) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap(restriction));
        return this;
    }

    @Override
    public SqmAttributeJoin<O, T> on(Expression<Boolean> restriction) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap((Expression)restriction));
        return this;
    }

    @Override
    public SqmAttributeJoin<O, T> on(JpaPredicate ... restrictions) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap(restrictions));
        return this;
    }

    @Override
    public SqmAttributeJoin<O, T> on(Predicate ... restrictions) {
        this.applyRestriction((SqmPredicate)this.nodeBuilder().wrap((Expression[])restrictions));
        return this;
    }

    public Predicate getOn() {
        return this.getJoinPredicate();
    }

    public SqmFrom<?, O> getParent() {
        return this.getLhs();
    }

    public JoinType getJoinType() {
        return this.getSqmJoinType().getCorrespondingJpaJoinType();
    }
}

