/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmPolymorphicRootDescriptor<T>
implements EntityDomainType<T> {
    private final Set<EntityDomainType<?>> implementors;
    private final Map<String, PersistentAttribute> commonAttributes;
    private final JavaType<T> polymorphicJavaDescriptor;

    public SqmPolymorphicRootDescriptor(JavaType<T> polymorphicJavaDescriptor, Set<EntityDomainType<?>> implementors) {
        this.polymorphicJavaDescriptor = polymorphicJavaDescriptor;
        this.implementors = implementors;
        HashMap workMap = new HashMap();
        ArrayList implementorsList = new ArrayList(implementors);
        EntityDomainType<?> firstImplementor = implementorsList.get(0);
        if (implementorsList.size() == 1) {
            firstImplementor.visitAttributes((PersistentAttribute<J, ?> attribute) -> workMap.put(attribute.getName(), attribute));
        } else {
            List<EntityDomainType<?>> subList = implementorsList.subList(1, implementors.size() - 1);
            firstImplementor.visitAttributes((PersistentAttribute<J, ?> attribute) -> {
                EntityDomainType navigable;
                Iterator iterator = subList.iterator();
                while (iterator.hasNext() && (navigable = (EntityDomainType)iterator.next()).findAttribute(attribute.getName()) != null) {
                    workMap.put(attribute.getName(), attribute);
                }
            });
        }
        this.commonAttributes = Collections.unmodifiableMap(workMap);
    }

    public Set<EntityDomainType<?>> getImplementors() {
        return new HashSet(this.implementors);
    }

    public String getName() {
        return this.polymorphicJavaDescriptor.getJavaType().getTypeName();
    }

    @Override
    public String getHibernateEntityName() {
        return this.getName();
    }

    @Override
    public String getTypeName() {
        return this.getName();
    }

    @Override
    public String getPathName() {
        return this.getName();
    }

    @Override
    public DomainType<?> getSqmPathType() {
        return this;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public Class<T> getBindableJavaType() {
        return this.polymorphicJavaDescriptor.getJavaTypeClass();
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    public Class<T> getJavaType() {
        return this.getBindableJavaType();
    }

    @Override
    public JavaType<T> getExpressableJavaTypeDescriptor() {
        return this.polymorphicJavaDescriptor;
    }

    @Override
    public PersistentAttribute findAttribute(String name) {
        return this.commonAttributes.get(name);
    }

    @Override
    public PersistentAttribute findSubTypesAttribute(String name) {
        return this.commonAttributes.get(name);
    }

    @Override
    public PersistentAttribute<? super T, ?> findAttributeInSuperTypes(String name) {
        return null;
    }

    @Override
    public void visitAttributes(Consumer<PersistentAttribute<T, ?>> action) {
        this.commonAttributes.values().forEach(action);
    }

    @Override
    public void visitDeclaredAttributes(Consumer<PersistentAttribute<T, ?>> action) {
    }

    @Override
    public PersistentAttribute<? super T, ?> getAttribute(String name) {
        PersistentAttribute attribute = this.findAttribute(name);
        if (attribute == null) {
            throw new IllegalArgumentException();
        }
        return attribute;
    }

    @Override
    public PersistentAttribute<T, ?> getDeclaredAttribute(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public SingularPersistentAttribute<? super T, ?> findSingularAttribute(String name) {
        return (SingularPersistentAttribute)this.findAttribute(name);
    }

    @Override
    public PluralPersistentAttribute<? super T, ?, ?> findPluralAttribute(String name) {
        return (PluralPersistentAttribute)this.findAttribute(name);
    }

    @Override
    public PersistentAttribute<T, ?> findDeclaredAttribute(String name) {
        return null;
    }

    @Override
    public SingularPersistentAttribute<? super T, ?> findDeclaredSingularAttribute(String name) {
        return null;
    }

    @Override
    public PluralPersistentAttribute<? super T, ?, ?> findDeclaredPluralAttribute(String name) {
        return null;
    }

    public Set<Attribute<? super T, ?>> getAttributes() {
        return (Set)((Object)this.commonAttributes);
    }

    public Set<Attribute<T, ?>> getDeclaredAttributes() {
        return Collections.emptySet();
    }

    public <Y> SingularAttribute<? super T, Y> getSingularAttribute(String name, Class<Y> type) {
        return (SingularAttribute)this.getAttribute(name);
    }

    public <Y> SingularAttribute<T, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        return (SingularAttribute)this.getDeclaredAttribute(name);
    }

    public Set<SingularAttribute<? super T, ?>> getSingularAttributes() {
        return this.commonAttributes.values().stream().filter(attribute -> attribute instanceof SingularAttribute).collect(Collectors.toSet());
    }

    public Set<SingularAttribute<T, ?>> getDeclaredSingularAttributes() {
        return Collections.emptySet();
    }

    public <E> CollectionAttribute<? super T, E> getCollection(String name, Class<E> elementType) {
        return (CollectionAttribute)this.getAttribute(name);
    }

    public <E> CollectionAttribute<T, E> getDeclaredCollection(String name, Class<E> elementType) {
        throw new IllegalArgumentException();
    }

    public <E> SetAttribute<? super T, E> getSet(String name, Class<E> elementType) {
        return (SetAttribute)this.getAttribute(name);
    }

    public <E> SetAttribute<T, E> getDeclaredSet(String name, Class<E> elementType) {
        throw new IllegalArgumentException();
    }

    public <E> ListAttribute<? super T, E> getList(String name, Class<E> elementType) {
        return (ListAttribute)this.getAttribute(name);
    }

    public <E> ListAttribute<T, E> getDeclaredList(String name, Class<E> elementType) {
        throw new IllegalArgumentException();
    }

    public <K, V> MapAttribute<? super T, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        return (MapAttribute)this.getAttribute(name);
    }

    public <K, V> MapAttribute<T, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        throw new IllegalArgumentException();
    }

    public Set<PluralAttribute<? super T, ?, ?>> getPluralAttributes() {
        return this.commonAttributes.values().stream().filter(attribute -> attribute instanceof PluralAttribute).collect(Collectors.toSet());
    }

    public Set<PluralAttribute<T, ?, ?>> getDeclaredPluralAttributes() {
        return Collections.emptySet();
    }

    public SingularAttribute<? super T, ?> getSingularAttribute(String name) {
        return (SingularAttribute)this.getAttribute(name);
    }

    public SingularAttribute<T, ?> getDeclaredSingularAttribute(String name) {
        throw new IllegalArgumentException();
    }

    public CollectionAttribute<? super T, ?> getCollection(String name) {
        return (CollectionAttribute)this.getAttribute(name);
    }

    public CollectionAttribute<T, ?> getDeclaredCollection(String name) {
        throw new IllegalArgumentException();
    }

    public SetAttribute<? super T, ?> getSet(String name) {
        return (SetAttribute)this.getAttribute(name);
    }

    public SetAttribute<T, ?> getDeclaredSet(String name) {
        throw new IllegalArgumentException();
    }

    public ListAttribute<? super T, ?> getList(String name) {
        return (ListAttribute)this.getAttribute(name);
    }

    public ListAttribute<T, ?> getDeclaredList(String name) {
        throw new IllegalArgumentException();
    }

    public MapAttribute<? super T, ?, ?> getMap(String name) {
        return (MapAttribute)this.getAttribute(name);
    }

    public MapAttribute<T, ?, ?> getDeclaredMap(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return (SqmPathSource)((Object)this.findAttribute(name));
    }

    @Override
    public SqmPath<T> createSqmPath(SqmPath<?> lhs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepresentationMode getRepresentationMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public SubGraphImplementor<T> makeSubGraph() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S extends T> SubGraphImplementor<S> makeSubGraph(Class<S> subType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S extends T> ManagedDomainType<S> findSubType(String subTypeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S extends T> ManagedDomainType<S> findSubType(Class<S> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqmPathSource<?> getIdentifierDescriptor() {
        return null;
    }

    @Override
    public <Y> SingularPersistentAttribute<? super T, Y> getId(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Y> SingularPersistentAttribute<T, Y> getDeclaredId(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Y> SingularPersistentAttribute<? super T, Y> getVersion(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Y> SingularPersistentAttribute<T, Y> getDeclaredVersion(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<SingularAttribute<? super T, ?>> getIdClassAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleDomainType<?> getIdType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IdentifiableDomainType<? super T> getSupertype() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasIdClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SingularPersistentAttribute<T, ?> findIdAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitIdClassAttributes(Consumer<SingularPersistentAttribute<? super T, ?>> action) {
    }

    @Override
    public SingularPersistentAttribute<? super T, ?> findVersionAttribute() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSingleIdAttribute() {
        throw new UnsupportedOperationException();
    }

    public boolean hasVersionAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ManagedDomainType<? super T> getSuperType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSubType(ManagedDomainType subType) {
        throw new UnsupportedOperationException();
    }
}

