/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmJoin;

public class SqmTreatedEntityJoin<T, S extends T>
extends SqmEntityJoin<S>
implements SqmTreatedPath<T, S> {
    private final SqmEntityJoin<T> wrappedPath;
    private final EntityDomainType<S> treatTarget;

    public SqmTreatedEntityJoin(SqmEntityJoin<T> wrappedPath, EntityDomainType<S> treatTarget, String alias, SqmJoinType joinType) {
        super(treatTarget, alias, joinType, wrappedPath.getRoot());
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    @Override
    public void addSqmJoin(SqmJoin<S, ?> join) {
        super.addSqmJoin(join);
        this.wrappedPath.addSqmJoin(join);
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SqmPathSource<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getReferencedPathSource() {
        return this.wrappedPath.getReferencedPathSource();
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

