/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.criteria.JpaSearchedCase;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public class SqmCaseSearched<R>
extends AbstractSqmExpression<R>
implements JpaSearchedCase<R>,
DomainResultProducer<R> {
    private final List<WhenFragment<R>> whenFragments;
    private SqmExpression<R> otherwise;

    public SqmCaseSearched(NodeBuilder nodeBuilder) {
        this((SqmExpressable<R>)null, nodeBuilder);
    }

    public SqmCaseSearched(SqmExpressable<R> inherentType, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.whenFragments = new ArrayList<WhenFragment<R>>();
    }

    public SqmCaseSearched(SqmExpressable<R> inherentType, int estimateWhenSize, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.whenFragments = new ArrayList<WhenFragment<R>>(estimateWhenSize);
    }

    public List<WhenFragment<R>> getWhenFragments() {
        return this.whenFragments;
    }

    public SqmExpression<R> getOtherwise() {
        return this.otherwise;
    }

    public SqmCaseSearched<R> when(SqmPredicate predicate, SqmExpression<R> result) {
        this.whenFragments.add(new WhenFragment<R>(predicate, result));
        this.applyInferableResultType(result.getNodeType());
        return this;
    }

    @Override
    public SqmCaseSearched<R> otherwise(SqmExpression<R> otherwiseExpression) {
        this.otherwise = otherwiseExpression;
        this.applyInferableResultType(otherwiseExpression.getNodeType());
        return this;
    }

    private void applyInferableResultType(SqmExpressable<?> type) {
        if (type == null) {
            return;
        }
        SqmExpressable oldType = this.getNodeType();
        SqmExpressable newType = QueryHelper.highestPrecedenceType2(oldType, type);
        if (newType != null && newType != oldType) {
            this.internalApplyInferableType(newType);
        }
    }

    @Override
    protected void internalApplyInferableType(SqmExpressable<?> newType) {
        super.internalApplyInferableType(newType);
        if (this.otherwise != null) {
            this.otherwise.applyInferableType(newType);
        }
        if (this.whenFragments != null) {
            this.whenFragments.forEach(whenFragment -> whenFragment.getResult().applyInferableType(newType));
        }
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitSearchedCaseExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "<searched-case>";
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("case");
        for (WhenFragment<R> whenFragment : this.whenFragments) {
            sb.append(" when ");
            ((WhenFragment)whenFragment).predicate.appendHqlString(sb);
            sb.append(" then ");
            ((WhenFragment)whenFragment).result.appendHqlString(sb);
        }
        if (this.otherwise != null) {
            sb.append(" else ");
            this.otherwise.appendHqlString(sb);
        }
        sb.append(" end");
    }

    @Override
    public SqmCaseSearched<R> when(Expression<Boolean> condition, R result) {
        this.when((SqmPredicate)this.nodeBuilder().wrap((Expression)condition), this.nodeBuilder().value(result, this.otherwise));
        return this;
    }

    @Override
    public SqmCaseSearched<R> when(Expression<Boolean> condition, Expression<? extends R> result) {
        this.when((SqmPredicate)this.nodeBuilder().wrap((Expression)condition), (SqmExpression)result);
        return this;
    }

    @Override
    public SqmExpression<R> otherwise(R result) {
        this.otherwise(this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public SqmExpression<R> otherwise(Expression<? extends R> result) {
        this.otherwise((SqmExpression)result);
        return this;
    }

    public static class WhenFragment<R> {
        private final SqmPredicate predicate;
        private final SqmExpression<R> result;

        public WhenFragment(SqmPredicate predicate, SqmExpression<R> result) {
            this.predicate = predicate;
            this.result = result;
        }

        public SqmPredicate getPredicate() {
            return this.predicate;
        }

        public SqmExpression<R> getResult() {
            return this.result;
        }
    }
}

