/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.hql.HqlInterpretationException;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class SqmLiteralEntityType<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T>,
SemanticPathPart {
    private final EntityDomainType<T> entityType;

    public SqmLiteralEntityType(EntityDomainType<T> entityType, NodeBuilder nodeBuilder) {
        super(entityType, nodeBuilder);
        this.entityType = entityType;
    }

    @Override
    public EntityDomainType<T> getNodeType() {
        return this.entityType;
    }

    @Override
    public void internalApplyInferableType(SqmExpressable<?> type) {
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEntityTypeLiteralExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "TYPE(" + this.entityType + ")";
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new HqlInterpretationException("Cannot dereference an entity name");
    }

    public SqmPath resolveIndexedAccess(SqmExpression selector, boolean isTerminal, SqmCreationState creationState) {
        throw new HqlInterpretationException("Cannot dereference an entity name");
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.entityType.getName());
    }
}

