/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class SqmRestrictedSubQueryExpression<T>
extends AbstractSqmExpression<T> {
    private final SqmSubQuery<T> subQuery;
    private final Modifier modifier;

    public SqmRestrictedSubQueryExpression(SqmSubQuery<T> subquery, Modifier modifier, NodeBuilder builder) {
        this(subquery, modifier, subquery.getNodeType(), builder);
    }

    public SqmRestrictedSubQueryExpression(SqmSubQuery<T> subQuery, Modifier modifier, SqmExpressable<T> resultType, NodeBuilder builder) {
        super(resultType, builder);
        this.subQuery = subQuery;
        this.modifier = modifier;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public SqmSubQuery<T> getSubQuery() {
        return this.subQuery;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitRestrictedSubQueryExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append((Object)this.modifier);
        sb.append(" (");
        this.subQuery.appendHqlString(sb);
        sb.append(')');
    }

    public static enum Modifier {
        ALL,
        ANY,
        SOME;

    }
}

