/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import java.util.Collections;
import java.util.List;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;

public class SqmBooleanExpressionPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<Boolean> booleanExpression;

    public SqmBooleanExpressionPredicate(SqmExpression<Boolean> booleanExpression, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        assert (booleanExpression.getNodeType() != null);
        Class<Boolean> expressionJavaType = booleanExpression.getNodeType().getExpressableJavaTypeDescriptor().getJavaTypeClass();
        assert (Boolean.TYPE.equals(expressionJavaType) || Boolean.class.equals(expressionJavaType));
        this.booleanExpression = booleanExpression;
    }

    public SqmExpression<Boolean> getBooleanExpression() {
        return this.booleanExpression;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitBooleanExpressionPredicate(this);
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        return Collections.singletonList(this.booleanExpression);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.booleanExpression.appendHqlString(sb);
    }
}

