/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;

public class SqmInListPredicate<T>
extends AbstractNegatableSqmPredicate
implements SqmInPredicate<T> {
    private final SqmExpression<T> testExpression;
    private final List<SqmExpression<T>> listExpressions;

    public SqmInListPredicate(SqmExpression<T> testExpression, NodeBuilder nodeBuilder) {
        this(testExpression, new ArrayList(), nodeBuilder);
    }

    public SqmInListPredicate(SqmExpression<T> testExpression, NodeBuilder nodeBuilder, SqmExpression<T> ... listExpressions) {
        this(testExpression, ArrayHelper.toExpandableList(listExpressions), nodeBuilder);
    }

    public SqmInListPredicate(SqmExpression<T> testExpression, List<? extends SqmExpression<T>> listExpressions, NodeBuilder nodeBuilder) {
        this(testExpression, listExpressions, false, nodeBuilder);
    }

    public SqmInListPredicate(SqmExpression<T> testExpression, List<? extends SqmExpression<T>> listExpressions, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.testExpression = testExpression;
        this.listExpressions = listExpressions;
        for (SqmExpression<T> listExpression : listExpressions) {
            this.implyListElementType(listExpression);
        }
    }

    @Override
    public SqmExpression<T> getTestExpression() {
        return this.testExpression;
    }

    @Override
    public SqmExpression<T> getExpression() {
        return this.getTestExpression();
    }

    @Override
    public SqmInPredicate<T> value(Object value) {
        if (value instanceof Collection) {
            ((Collection)value).forEach(v -> this.addExpression(this.nodeBuilder().value(v, this.testExpression)));
        } else {
            this.addExpression(this.nodeBuilder().value(value, this.testExpression));
        }
        return this;
    }

    @Override
    public SqmInPredicate<T> value(Expression<? extends T> value) {
        this.addExpression((SqmExpression)value);
        return this;
    }

    @Override
    public SqmInPredicate<T> value(JpaExpression<? extends T> value) {
        this.addExpression((SqmExpression)value);
        return this;
    }

    public List<? extends SqmExpression<T>> getListExpressions() {
        return this.listExpressions;
    }

    public void addExpression(SqmExpression<T> expression) {
        this.implyListElementType(expression);
        this.listExpressions.add(expression);
    }

    private void implyListElementType(SqmExpression<?> expression) {
        expression.applyInferableType(QueryHelper.highestPrecedenceType2(this.getTestExpression().getNodeType(), expression.getNodeType()));
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitInListPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.testExpression.appendHqlString(sb);
        if (this.isNegated()) {
            sb.append(" not");
        }
        sb.append(" in (");
        this.listExpressions.get(0).appendHqlString(sb);
        for (int i = 1; i < this.listExpressions.size(); ++i) {
            sb.append(", ");
            this.listExpressions.get(i).appendHqlString(sb);
        }
        sb.append(')');
    }
}

