/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import java.util.Collections;
import java.util.List;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public class SqmNegatedPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmPredicate wrappedPredicate;

    public SqmNegatedPredicate(SqmPredicate wrappedPredicate, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.wrappedPredicate = wrappedPredicate;
    }

    public SqmPredicate getWrappedPredicate() {
        return this.wrappedPredicate;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        return Collections.singletonList(this.wrappedPredicate);
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitNegatedPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("not (");
        this.wrappedPredicate.appendHqlString(sb);
        sb.append(')');
    }
}

