/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.query.DynamicInstantiationNature;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.jpa.AbstractJpaSelection;
import org.hibernate.query.sqm.tree.select.SqmAliasedExpressionContainer;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.type.descriptor.java.JavaType;
import org.jboss.logging.Logger;

public class SqmDynamicInstantiation<T>
extends AbstractJpaSelection<T>
implements SqmSelectableNode<T>,
SqmAliasedExpressionContainer<SqmDynamicInstantiationArgument<?>>,
JpaCompoundSelection<T>,
DomainResultProducer<T> {
    private static final Logger log = Logger.getLogger(SqmDynamicInstantiation.class);
    private final SqmDynamicInstantiationTarget<T> instantiationTarget;
    private List<SqmDynamicInstantiationArgument<?>> arguments;

    public static <R> SqmDynamicInstantiation<R> forClassInstantiation(JavaType<R> targetJavaType, NodeBuilder nodeBuilder) {
        return new SqmDynamicInstantiation(new DynamicInstantiationTargetImpl(DynamicInstantiationNature.CLASS, targetJavaType), nodeBuilder);
    }

    public static <R> SqmDynamicInstantiation<R> forClassInstantiation(Class<R> targetJavaType, NodeBuilder nodeBuilder) {
        return SqmDynamicInstantiation.forClassInstantiation(nodeBuilder.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(targetJavaType), nodeBuilder);
    }

    public static <M extends Map<?, ?>> SqmDynamicInstantiation<M> forMapInstantiation(JavaType<M> mapJavaTypeDescriptor, NodeBuilder nodeBuilder) {
        return new SqmDynamicInstantiation(new DynamicInstantiationTargetImpl(DynamicInstantiationNature.MAP, mapJavaTypeDescriptor), nodeBuilder);
    }

    public static <M extends Map<?, ?>> SqmDynamicInstantiation<M> forMapInstantiation(NodeBuilder nodeBuilder) {
        return SqmDynamicInstantiation.forMapInstantiation(nodeBuilder.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Map.class)), nodeBuilder);
    }

    public static <L extends List<?>> SqmDynamicInstantiation<L> forListInstantiation(JavaType<L> listJavaTypeDescriptor, NodeBuilder nodeBuilder) {
        return new SqmDynamicInstantiation(new DynamicInstantiationTargetImpl(DynamicInstantiationNature.LIST, listJavaTypeDescriptor), nodeBuilder);
    }

    public static <L extends List<?>> SqmDynamicInstantiation<L> forListInstantiation(NodeBuilder nodeBuilder) {
        return SqmDynamicInstantiation.forListInstantiation(nodeBuilder.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)List.class)), nodeBuilder);
    }

    private SqmDynamicInstantiation(SqmDynamicInstantiationTarget<T> instantiationTarget, NodeBuilder nodeBuilder) {
        super(instantiationTarget, nodeBuilder);
        this.instantiationTarget = instantiationTarget;
    }

    public SqmDynamicInstantiationTarget<T> getInstantiationTarget() {
        return this.instantiationTarget;
    }

    public List<SqmDynamicInstantiationArgument<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public JavaType<T> getJavaTypeDescriptor() {
        return this.getInstantiationTarget().getTargetTypeDescriptor();
    }

    @Override
    public String asLoggableText() {
        return "<new " + this.instantiationTarget.getJavaType().getName() + ">";
    }

    public void addArgument(SqmDynamicInstantiationArgument<?> argument) {
        if (this.instantiationTarget.getNature() == DynamicInstantiationNature.LIST) {
            if (argument.getAlias() != null && log.isDebugEnabled()) {
                log.debugf("Argument [%s] for dynamic List instantiation declared an 'injection alias' [%s] but such aliases are ignored for dynamic List instantiations", (Object)argument.getSelectableNode().asLoggableText(), (Object)argument.getAlias());
            }
        } else if (this.instantiationTarget.getNature() == DynamicInstantiationNature.MAP) {
            log.warnf("Argument [%s] for dynamic Map instantiation did not declare an 'injection alias' [%s] but such aliases are needed for dynamic Map instantiations; will likely cause problems later translating sqm", (Object)argument.getSelectableNode().asLoggableText(), (Object)argument.getAlias());
        }
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        this.arguments.add(argument);
    }

    @Override
    public SqmDynamicInstantiationArgument<?> add(SqmExpression<?> expression, String alias) {
        SqmDynamicInstantiationArgument argument = new SqmDynamicInstantiationArgument(expression, alias, this.nodeBuilder());
        this.addArgument(argument);
        return argument;
    }

    @Override
    public void add(SqmDynamicInstantiationArgument<?> aliasExpression) {
        this.addArgument(aliasExpression);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitDynamicInstantiation(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("new ");
        if (this.instantiationTarget.getNature() == DynamicInstantiationNature.LIST) {
            sb.append("list");
        } else if (this.instantiationTarget.getNature() == DynamicInstantiationNature.MAP) {
            sb.append("map");
        } else {
            sb.append(this.instantiationTarget.getTargetTypeDescriptor().getJavaTypeClass().getTypeName());
        }
        sb.append('(');
        ((SqmSelectableNode)((Object)this.arguments.get(0))).appendHqlString(sb);
        for (int i = 1; i < this.arguments.size(); ++i) {
            sb.append(", ");
            ((SqmSelectableNode)((Object)this.arguments.get(i))).appendHqlString(sb);
        }
        sb.append(')');
    }

    public SqmDynamicInstantiation<T> makeShallowCopy() {
        return new SqmDynamicInstantiation<T>(this.getInstantiationTarget(), this.nodeBuilder());
    }

    @Override
    public void visitSubSelectableNodes(Consumer<SqmSelectableNode<?>> consumer) {
        for (SqmDynamicInstantiationArgument<?> argument : this.arguments) {
            consumer.accept(argument.getSelectableNode());
        }
    }

    @Override
    public List<SqmSelectableNode<?>> getSelectionItems() {
        ArrayList list = new ArrayList();
        this.visitSubSelectableNodes(list::add);
        return list;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public JpaSelection<T> alias(String name) {
        return null;
    }

    @Override
    public boolean isCompoundSelection() {
        return false;
    }

    private static class DynamicInstantiationTargetImpl<T>
    implements SqmDynamicInstantiationTarget<T> {
        private final DynamicInstantiationNature nature;
        private final JavaType<T> javaTypeDescriptor;

        private DynamicInstantiationTargetImpl(DynamicInstantiationNature nature, JavaType<T> javaTypeDescriptor) {
            this.nature = nature;
            this.javaTypeDescriptor = javaTypeDescriptor;
        }

        @Override
        public DynamicInstantiationNature getNature() {
            return this.nature;
        }

        @Override
        public JavaType<T> getTargetTypeDescriptor() {
            return this.javaTypeDescriptor;
        }

        @Override
        public JavaType<T> getExpressableJavaTypeDescriptor() {
            return this.getTargetTypeDescriptor();
        }
    }
}

