/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmFromClauseContainer;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClauseContainer;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;

public class SqmQuerySpec<T>
extends SqmQueryPart<T>
implements SqmNode,
SqmFromClauseContainer,
SqmWhereClauseContainer,
JpaQueryStructure<T> {
    private SqmFromClause fromClause;
    private SqmSelectClause selectClause;
    private SqmWhereClause whereClause;
    private boolean hasPositionalGroupItem;
    private List<SqmExpression<?>> groupByClauseExpressions = Collections.emptyList();
    private SqmPredicate havingClausePredicate;

    public SqmQuerySpec(NodeBuilder nodeBuilder) {
        super(nodeBuilder);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQuerySpec(this);
    }

    @Override
    public SqmQuerySpec<T> getFirstQuerySpec() {
        return this;
    }

    @Override
    public SqmQuerySpec<T> getLastQuerySpec() {
        return this;
    }

    @Override
    public boolean isSimpleQueryPart() {
        return true;
    }

    @Override
    public SqmFromClause getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(SqmFromClause fromClause) {
        this.fromClause = fromClause;
    }

    public boolean containsCollectionFetches() {
        ArrayList fromNodes = new ArrayList(this.fromClause.getRoots());
        while (!fromNodes.isEmpty()) {
            SqmFrom fromNode = (SqmFrom)fromNodes.remove(fromNodes.size() - 1);
            for (SqmJoin sqmJoin : fromNode.getSqmJoins()) {
                SqmAttributeJoin join;
                if (sqmJoin instanceof SqmAttributeJoin && (join = (SqmAttributeJoin)sqmJoin).isFetched() && join.getAttribute().isCollection()) {
                    return true;
                }
                fromNodes.add((SqmRoot<?>)((Object)sqmJoin));
            }
        }
        return false;
    }

    public SqmSelectClause getSelectClause() {
        return this.selectClause;
    }

    public void setSelectClause(SqmSelectClause selectClause) {
        this.selectClause = selectClause;
    }

    @Override
    public SqmWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(SqmWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public void applyPredicate(SqmPredicate predicate) {
        if (predicate == null) {
            return;
        }
        if (this.whereClause == null) {
            this.whereClause = new SqmWhereClause(this.nodeBuilder());
        }
        this.whereClause.applyPredicate(predicate);
    }

    public boolean hasPositionalGroupItem() {
        return this.hasPositionalGroupItem;
    }

    public List<SqmExpression<?>> getGroupByClauseExpressions() {
        return this.groupByClauseExpressions;
    }

    public void setGroupByClauseExpressions(List<SqmExpression<?>> groupByClauseExpressions) {
        this.hasPositionalGroupItem = false;
        if (groupByClauseExpressions == null) {
            this.groupByClauseExpressions = Collections.emptyList();
        } else {
            this.groupByClauseExpressions = groupByClauseExpressions;
            for (int i = 0; i < groupByClauseExpressions.size(); ++i) {
                SqmExpression<?> groupItem = groupByClauseExpressions.get(i);
                if (!(groupItem instanceof SqmAliasedNodeRef)) continue;
                this.hasPositionalGroupItem = true;
                break;
            }
        }
    }

    public SqmPredicate getHavingClausePredicate() {
        return this.havingClausePredicate;
    }

    public void setHavingClausePredicate(SqmPredicate havingClausePredicate) {
        this.havingClausePredicate = havingClausePredicate;
    }

    @Override
    public boolean isDistinct() {
        assert (this.getSelectClause() != null);
        return this.getSelectClause().isDistinct();
    }

    @Override
    public SqmQuerySpec<T> setDistinct(boolean distinct) {
        assert (this.getSelectClause() != null);
        this.getSelectClause().makeDistinct(distinct);
        return this;
    }

    @Override
    public JpaSelection<T> getSelection() {
        assert (this.getSelectClause() != null);
        return this.getSelectClause().resolveJpaSelection();
    }

    @Override
    public SqmQuerySpec<T> setSelection(JpaSelection<T> selection) {
        assert (this.getSelectClause() != null);
        this.getSelectClause().setSelection((SqmSelectableNode)selection);
        return this;
    }

    @Override
    public Set<SqmRoot<?>> getRoots() {
        assert (this.getFromClause() != null);
        return new HashSet(this.getFromClause().getRoots());
    }

    @Override
    public SqmQuerySpec<T> addRoot(JpaRoot<?> root) {
        if (this.getFromClause() == null) {
            this.setFromClause(new SqmFromClause());
        }
        this.getFromClause().addRoot((SqmRoot)root);
        return this;
    }

    @Override
    public SqmPredicate getRestriction() {
        if (this.getWhereClause() == null) {
            return null;
        }
        return this.getWhereClause().getPredicate();
    }

    @Override
    public SqmQuerySpec<T> setRestriction(JpaPredicate restriction) {
        SqmWhereClause whereClause = this.getWhereClause();
        if (whereClause == null) {
            whereClause = new SqmWhereClause(this.nodeBuilder());
            this.setWhereClause(whereClause);
        }
        whereClause.setPredicate((SqmPredicate)restriction);
        return this;
    }

    @Override
    public SqmQuerySpec<T> setRestriction(Expression<Boolean> restriction) {
        SqmWhereClause whereClause = this.getWhereClause();
        if (whereClause == null) {
            whereClause = new SqmWhereClause(this.nodeBuilder());
            this.setWhereClause(whereClause);
        }
        whereClause.setPredicate((SqmPredicate)this.nodeBuilder().wrap((Expression)restriction));
        return this;
    }

    @Override
    public SqmQuerySpec<T> setRestriction(Predicate ... restrictions) {
        SqmWhereClause whereClause = this.getWhereClause();
        if (whereClause == null) {
            whereClause = new SqmWhereClause(this.nodeBuilder());
            this.setWhereClause(whereClause);
        }
        for (Predicate restriction : restrictions) {
            whereClause.applyPredicate((SqmPredicate)restriction);
        }
        return this;
    }

    @Override
    public List<SqmExpression<?>> getGroupingExpressions() {
        return this.groupByClauseExpressions;
    }

    @Override
    public SqmQuerySpec<T> setGroupingExpressions(List<? extends JpaExpression<?>> groupExpressions) {
        this.hasPositionalGroupItem = false;
        this.groupByClauseExpressions = new ArrayList(groupExpressions.size());
        for (JpaExpression<?> groupExpression : groupExpressions) {
            if (groupExpression instanceof SqmAliasedNodeRef) {
                this.hasPositionalGroupItem = true;
            }
            this.groupByClauseExpressions.add((SqmExpression)groupExpression);
        }
        return this;
    }

    @Override
    public SqmQuerySpec<T> setGroupingExpressions(JpaExpression<?> ... groupExpressions) {
        this.hasPositionalGroupItem = false;
        this.groupByClauseExpressions = new ArrayList(groupExpressions.length);
        for (JpaExpression<?> groupExpression : groupExpressions) {
            if (groupExpression instanceof SqmAliasedNodeRef) {
                this.hasPositionalGroupItem = true;
            }
            this.groupByClauseExpressions.add((SqmExpression)groupExpression);
        }
        return this;
    }

    @Override
    public SqmPredicate getGroupRestriction() {
        return this.havingClausePredicate;
    }

    @Override
    public SqmQuerySpec<T> setGroupRestriction(JpaPredicate restriction) {
        this.havingClausePredicate = (SqmPredicate)restriction;
        return this;
    }

    @Override
    public SqmQuerySpec<T> setGroupRestriction(Expression<Boolean> restriction) {
        this.havingClausePredicate = this.nodeBuilder().wrap((Expression)restriction);
        return this;
    }

    @Override
    public SqmQuerySpec<T> setGroupRestriction(Predicate ... restrictions) {
        this.havingClausePredicate = this.nodeBuilder().wrap((Expression[])restrictions);
        return this;
    }

    @Override
    public SqmQuerySpec<T> setSortSpecifications(List<? extends JpaOrder> sortSpecifications) {
        super.setSortSpecifications((List)sortSpecifications);
        return this;
    }

    @Override
    public SqmExpression<?> getOffset() {
        return this.getOffsetExpression();
    }

    @Override
    public SqmQuerySpec<T> setOffset(JpaExpression<?> offset) {
        this.setOffsetExpression((SqmExpression)offset);
        return this;
    }

    @Override
    public SqmExpression<?> getFetch() {
        return this.getFetchExpression();
    }

    @Override
    public SqmQuerySpec<T> setFetch(JpaExpression<?> fetch) {
        this.setFetchExpression((SqmExpression)fetch);
        return this;
    }

    @Override
    public SqmQuerySpec<T> setFetch(JpaExpression<?> fetch, FetchClauseType fetchClauseType) {
        this.setFetchExpression((SqmExpression)fetch, fetchClauseType);
        return this;
    }

    @Override
    public void validateQueryGroupFetchStructure() {
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        if (this.selectClause != null) {
            sb.append("select ");
            if (this.selectClause.isDistinct()) {
                sb.append("distinct ");
            }
            List<SqmSelection<?>> selections = this.selectClause.getSelections();
            selections.get(0).appendHqlString(sb);
            for (int i = 1; i < selections.size(); ++i) {
                sb.append(", ");
                selections.get(i).appendHqlString(sb);
            }
        }
        if (this.fromClause != null) {
            sb.append(" from ");
            String separator = "";
            for (SqmRoot<?> root : this.fromClause.getRoots()) {
                sb.append(separator);
                if (root.isCorrelated()) {
                    if (root.containsOnlyInnerJoins()) {
                        this.appendJoins(root, root.getCorrelationParent().resolveAlias(), sb);
                    } else {
                        sb.append(root.getCorrelationParent().resolveAlias());
                        sb.append(' ').append(root.resolveAlias());
                        this.appendJoins(root, sb);
                    }
                } else {
                    sb.append(root.getEntityName());
                    sb.append(' ').append(root.resolveAlias());
                    this.appendJoins(root, sb);
                }
                separator = ", ";
            }
        }
        if (this.whereClause != null && this.whereClause.getPredicate() != null) {
            sb.append(" where ");
            this.whereClause.getPredicate().appendHqlString(sb);
        }
        if (!this.groupByClauseExpressions.isEmpty()) {
            sb.append(" group by ");
            this.groupByClauseExpressions.get(0).appendHqlString(sb);
            for (int i = 1; i < this.groupByClauseExpressions.size(); ++i) {
                sb.append(", ");
                this.groupByClauseExpressions.get(i).appendHqlString(sb);
            }
        }
        if (this.havingClausePredicate != null) {
            sb.append(" having ");
            this.havingClausePredicate.appendHqlString(sb);
        }
        super.appendHqlString(sb);
    }

    private void appendJoins(SqmFrom<?, ?> sqmFrom, StringBuilder sb) {
        for (SqmJoin<?, ?> sqmJoin : sqmFrom.getSqmJoins()) {
            switch (sqmJoin.getSqmJoinType()) {
                case LEFT: {
                    sb.append(" left join ");
                    break;
                }
                case RIGHT: {
                    sb.append(" right join ");
                    break;
                }
                case INNER: {
                    sb.append(" join ");
                    break;
                }
                case FULL: {
                    sb.append(" full join ");
                    break;
                }
                case CROSS: {
                    sb.append(" cross join ");
                }
            }
            if (sqmJoin instanceof SqmAttributeJoin) {
                SqmAttributeJoin attributeJoin = (SqmAttributeJoin)sqmJoin;
                sb.append(sqmFrom.resolveAlias()).append('.');
                sb.append(attributeJoin.getAttribute().getName());
                sb.append(' ').append(sqmJoin.resolveAlias());
                if (attributeJoin.getJoinPredicate() != null) {
                    sb.append(" on ");
                    attributeJoin.getJoinPredicate().appendHqlString(sb);
                }
                this.appendJoins(sqmJoin, sb);
                continue;
            }
            if (sqmJoin instanceof SqmCrossJoin) {
                sb.append(((SqmCrossJoin)sqmJoin).getEntityName());
                sb.append(' ').append(sqmJoin.resolveAlias());
                this.appendJoins(sqmJoin, sb);
                continue;
            }
            if (sqmJoin instanceof SqmEntityJoin) {
                SqmEntityJoin sqmEntityJoin = (SqmEntityJoin)sqmJoin;
                sb.append(sqmEntityJoin.getEntityName());
                sb.append(' ').append(sqmJoin.resolveAlias());
                if (sqmEntityJoin.getJoinPredicate() != null) {
                    sb.append(" on ");
                    sqmEntityJoin.getJoinPredicate().appendHqlString(sb);
                }
                this.appendJoins(sqmJoin, sb);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported join: " + sqmJoin);
        }
    }

    private void appendJoins(SqmFrom<?, ?> sqmFrom, String correlationPrefix, StringBuilder sb) {
        String separator = "";
        for (SqmJoin<?, ?> sqmJoin : sqmFrom.getSqmJoins()) {
            assert (sqmJoin instanceof SqmAttributeJoin);
            sb.append(separator);
            sb.append(correlationPrefix).append('.');
            sb.append(((SqmAttributeJoin)sqmJoin).getAttribute().getName());
            sb.append(' ').append(sqmJoin.resolveAlias());
            this.appendJoins(sqmJoin, sb);
            separator = ", ";
        }
    }
}

