/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class CompositeTableGroup
implements VirtualTableGroup {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart compositionMapping;
    private final TableGroup underlyingTableGroup;
    private final boolean fetched;
    private List<TableGroupJoin> tableGroupJoins;

    public CompositeTableGroup(NavigablePath navigablePath, EmbeddableValuedModelPart compositionMapping, TableGroup underlyingTableGroup, boolean fetched) {
        this.navigablePath = navigablePath;
        this.compositionMapping = compositionMapping;
        this.underlyingTableGroup = underlyingTableGroup;
        this.fetched = fetched;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EmbeddableValuedModelPart getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getGroupAlias() {
        return null;
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public EmbeddableValuedModelPart getModelPart() {
        return this.compositionMapping;
    }

    @Override
    public String getSourceAlias() {
        return this.underlyingTableGroup.getSourceAlias();
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroupJoins == null ? Collections.emptyList() : Collections.unmodifiableList(this.tableGroupJoins);
    }

    @Override
    public boolean canUseInnerJoins() {
        return this.underlyingTableGroup.canUseInnerJoins();
    }

    @Override
    public boolean hasTableGroupJoins() {
        return this.tableGroupJoins != null && !this.tableGroupJoins.isEmpty();
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new ArrayList<TableGroupJoin>();
        }
        if (!this.tableGroupJoins.contains(join)) {
            this.tableGroupJoins.add(join);
        }
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroupJoins != null) {
            this.tableGroupJoins.forEach(consumer);
        }
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        this.underlyingTableGroup.applyAffectedTableNames(nameCollector);
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.underlyingTableGroup.getPrimaryTableReference();
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.underlyingTableGroup.getTableReferenceJoins();
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        return this.underlyingTableGroup.getTableReference(navigablePath, tableExpression, allowFkOptimization);
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        TableReference tableReference = this.underlyingTableGroup.getTableReference(navigablePath, tableExpression, allowFkOptimization);
        if (tableReference != null) {
            return tableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            TableReference primaryTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization);
            if (primaryTableReference == null) continue;
            return primaryTableReference;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + tableExpression + "`");
    }
}

