/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableJoin;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class FromClause
implements SqlAstNode {
    private final List<TableGroup> roots;

    public FromClause() {
        this.roots = new ArrayList<TableGroup>();
    }

    public FromClause(int expectedNumberOfRoots) {
        this.roots = CollectionHelper.arrayList(expectedNumberOfRoots);
    }

    public List<TableGroup> getRoots() {
        return this.roots;
    }

    public void addRoot(TableGroup tableGroup) {
        this.roots.add(tableGroup);
    }

    public void visitRoots(Consumer<TableGroup> action) {
        this.roots.forEach(action);
    }

    public void visitTableGroups(Consumer<TableGroup> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            this.visitTableGroups(this.roots.get(i), action);
        }
    }

    private void visitTableGroups(TableGroup tableGroup, Consumer<TableGroup> action) {
        action.accept(tableGroup);
        List<TableGroupJoin> tableGroupJoins = tableGroup.getTableGroupJoins();
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            this.visitTableGroups(tableGroupJoins.get(i).getJoinedGroup(), action);
        }
    }

    public <T> T queryTableGroups(Function<TableGroup, T> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            T result = this.queryTableGroups(this.roots.get(i), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <T> T queryTableGroups(TableGroup tableGroup, Function<TableGroup, T> action) {
        T result = action.apply(tableGroup);
        if (result != null) {
            return result;
        }
        List<TableGroupJoin> tableGroupJoins = tableGroup.getTableGroupJoins();
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            T nestedResult = this.queryTableGroups(tableGroupJoins.get(i).getJoinedGroup(), action);
            if (nestedResult == null) continue;
            return nestedResult;
        }
        return null;
    }

    public void visitTableJoins(Consumer<TableJoin> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            this.visitTableJoins(this.roots.get(i), action);
        }
    }

    private void visitTableJoins(TableGroup tableGroup, Consumer<TableJoin> action) {
        tableGroup.getTableReferenceJoins().forEach(action);
        List<TableGroupJoin> tableGroupJoins = tableGroup.getTableGroupJoins();
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            TableGroupJoin tableGroupJoin = tableGroupJoins.get(i);
            action.accept(tableGroupJoin);
            this.visitTableJoins(tableGroupJoin.getJoinedGroup(), action);
        }
    }

    public <T> T queryTableJoins(Function<TableJoin, T> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            T result = this.queryTableJoins(this.roots.get(i), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <T> T queryTableJoins(TableGroup tableGroup, Function<TableJoin, T> action) {
        for (TableReferenceJoin tableReferenceJoin : tableGroup.getTableReferenceJoins()) {
            T result = action.apply(tableReferenceJoin);
            if (result == null) continue;
            return result;
        }
        List<TableGroupJoin> tableGroupJoins = tableGroup.getTableGroupJoins();
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            TableGroupJoin tableGroupJoin = tableGroupJoins.get(i);
            T result = action.apply(tableGroupJoin);
            if (result != null) {
                return result;
            }
            result = this.queryTableJoins(tableGroupJoin.getJoinedGroup(), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void visitTableGroupJoins(Consumer<TableGroupJoin> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            this.visitTableGroupJoins(this.roots.get(i), action);
        }
    }

    private void visitTableGroupJoins(TableGroup tableGroup, Consumer<TableGroupJoin> action) {
        List<TableGroupJoin> tableGroupJoins = tableGroup.getTableGroupJoins();
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            TableGroupJoin tableGroupJoin = tableGroupJoins.get(i);
            action.accept(tableGroupJoin);
            this.visitTableGroupJoins(tableGroupJoin.getJoinedGroup(), action);
        }
    }

    public <T> T queryTableGroupJoins(Function<TableGroupJoin, T> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            T result = this.queryTableGroupJoins(this.roots.get(i), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <T> T queryTableGroupJoins(TableGroup tableGroup, Function<TableGroupJoin, T> action) {
        List<TableGroupJoin> tableGroupJoins = tableGroup.getTableGroupJoins();
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            TableGroupJoin tableGroupJoin = tableGroupJoins.get(i);
            T result = action.apply(tableGroupJoin);
            if (result != null) {
                return result;
            }
            result = this.queryTableGroupJoins(tableGroupJoin.getJoinedGroup(), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitFromClause(this);
    }
}

