/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractJdbcParameter
implements JdbcParameter,
JdbcParameterBinder,
MappingModelExpressable,
SqlExpressable {
    private final JdbcMapping jdbcMapping;

    public AbstractJdbcParameter(JdbcMapping jdbcMapping) {
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public JdbcParameterBinder getParameterBinder() {
        return this;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, this);
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
        JdbcParameterBinding binding = jdbcParamBindings.getBinding(this);
        if (binding == null) {
            throw new ExecutionException("JDBC parameter value not bound - " + this);
        }
        JdbcMapping jdbcMapping = binding.getBindType();
        if (jdbcMapping == null) {
            jdbcMapping = this.jdbcMapping;
        }
        if (jdbcMapping == null || jdbcMapping.getMappedJavaTypeDescriptor().getJavaTypeClass() == Object.class) {
            jdbcMapping = this.guessBindType(executionContext, binding, jdbcMapping);
        }
        Object bindValue = binding.getBindValue();
        jdbcMapping.getJdbcValueBinder().bind(statement, bindValue, startPosition, (WrapperOptions)executionContext.getSession());
    }

    private JdbcMapping guessBindType(ExecutionContext executionContext, JdbcParameterBinding binding, JdbcMapping jdbcMapping) {
        Class valueClass;
        if (binding.getBindValue() == null) {
            if (jdbcMapping != null) {
                return jdbcMapping;
            }
            valueClass = Object.class;
        } else {
            valueClass = binding.getBindValue().getClass();
        }
        BasicType<Object> basicType = executionContext.getSession().getFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(valueClass);
        return basicType.getJdbcMapping();
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this;
    }

    @Override
    public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }
}

