/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.PreparedStatement;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.CacheMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.sql.exec.SqlExecLogger;
import org.hibernate.sql.exec.internal.JdbcExecHelper;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.jdbc.internal.DeferredResultSetAccess;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesCacheHit;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.sql.results.spi.ScrollableResultsConsumer;
import org.hibernate.stat.spi.StatisticsImplementor;

public class JdbcSelectExecutorStandardImpl
implements JdbcSelectExecutor {
    public static final JdbcSelectExecutorStandardImpl INSTANCE = new JdbcSelectExecutorStandardImpl();

    @Override
    public <R> List<R> list(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, ListResultsConsumer.UniqueSemantic uniqueSemantic) {
        return (List)this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), ListResultsConsumer.instance(uniqueSemantic));
    }

    @Override
    public <R> ScrollableResultsImplementor<R> scroll(JdbcSelect jdbcSelect, ScrollMode scrollMode, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        SharedSessionContractImplementor session = executionContext.getSession();
        session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames());
        return (ScrollableResultsImplementor)this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareQueryStatement((String)sql, false, scrollMode), ScrollableResultsConsumer.instance());
    }

    @Override
    public <R> Stream<R> stream(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        ScrollableResultsImplementor<R> scrollableResults = this.scroll(jdbcSelect, ScrollMode.FORWARD_ONLY, jdbcParameterBindings, executionContext, rowTransformer);
        ScrollableResultsIterator<R> iterator = new ScrollableResultsIterator<R>(scrollableResults);
        Spliterator<R> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream<R> stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(scrollableResults::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> T executeQuery(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        PersistenceContext persistenceContext = executionContext.getSession().getPersistenceContext();
        boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
        Boolean readOnly = executionContext.getQueryOptions().isReadOnly();
        if (readOnly != null) {
            persistenceContext.setDefaultReadOnly(readOnly);
        }
        try {
            T t = this.doExecuteQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, statementCreator, resultsConsumer);
            return t;
        }
        finally {
            if (readOnly != null) {
                persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
            }
        }
    }

    private <T, R> T doExecuteQuery(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, final ExecutionContext executionContext, RowTransformer<R> rowTransformer, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        boolean stats;
        DeferredResultSetAccess deferredResultSetAccess = new DeferredResultSetAccess(jdbcSelect, jdbcParameterBindings, executionContext, statementCreator);
        JdbcValues jdbcValues = this.resolveJdbcValuesSource(executionContext.getQueryIdentifier(deferredResultSetAccess.getFinalSql()), jdbcSelect, resultsConsumer.canResultsBeCached(), executionContext, deferredResultSetAccess);
        if (rowTransformer == null) {
            TupleTransformer tupleTransformer = executionContext.getQueryOptions().getTupleTransformer();
            if (tupleTransformer == null) {
                rowTransformer = RowTransformerPassThruImpl.instance();
            } else {
                List<DomainResult<?>> domainResults = jdbcValues.getValuesMapping().getDomainResults();
                String[] aliases = new String[domainResults.size()];
                for (int i = 0; i < domainResults.size(); ++i) {
                    aliases[i] = domainResults.get(i).getResultVariable();
                }
                rowTransformer = new RowTransformerTupleTransformerAdapter<R>(aliases, tupleTransformer);
            }
        }
        long startTime = 0L;
        StatisticsImplementor statistics = executionContext.getSession().getFactory().getStatistics();
        if (executionContext.hasQueryExecutionToBeAddedToStatistics() && jdbcValues instanceof JdbcValuesResultSetImpl) {
            stats = statistics.isStatisticsEnabled();
            if (stats) {
                startTime = System.nanoTime();
            }
        } else {
            stats = false;
        }
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return executionContext.getEntityInstance();
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Object getEffectiveOptionalId() {
                return executionContext.getEntityId();
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl valuesProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions, executionContext::registerLoadingEntityEntry);
        RowReader<R> rowReader = ResultsHelper.createRowReader(executionContext, deferredResultSetAccess.usesFollowOnLocking() ? LockOptions.NONE : executionContext.getQueryOptions().getLockOptions(), rowTransformer, jdbcValues);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(valuesProcessingState, executionContext, rowReader, jdbcValues);
        T result = resultsConsumer.consume(jdbcValues, executionContext.getSession(), processingOptions, valuesProcessingState, rowProcessingState, rowReader);
        if (stats) {
            long endTime = System.nanoTime();
            long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            statistics.queryExecuted(executionContext.getQueryIdentifier(jdbcSelect.getSql()), this.getResultSize(result), milliseconds);
        }
        return result;
    }

    private <T> int getResultSize(T result) {
        if (result instanceof List) {
            return ((List)result).size();
        }
        return -1;
    }

    private JdbcValues resolveJdbcValuesSource(String queryIdentifier, JdbcSelect jdbcSelect, boolean canBeCached, ExecutionContext executionContext, ResultSetAccess resultSetAccess) {
        List cachedResults;
        QueryKey queryResultsCacheKey;
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        boolean queryCacheEnabled = factory.getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = JdbcExecHelper.resolveCacheMode(executionContext);
        JdbcValuesMappingProducer mappingProducer = jdbcSelect.getJdbcValuesMappingProducer();
        JdbcValuesMapping jdbcValuesMapping = mappingProducer.resolve(resultSetAccess, factory);
        if (queryCacheEnabled && cacheMode.isGetEnabled() && canBeCached) {
            SqlExecLogger.INSTANCE.debugf("Reading Query result cache data per CacheMode#isGetEnabled [%s]", cacheMode.name());
            QueryResultsCache queryCache = factory.getCache().getQueryResultsCache(executionContext.getQueryOptions().getResultCacheRegionName());
            queryResultsCacheKey = QueryKey.from(jdbcSelect.getSql(), executionContext.getQueryOptions().getLimit(), executionContext.getQueryParameterBindings(), session);
            cachedResults = queryCache.get(queryResultsCacheKey, jdbcSelect.getAffectedTableNames(), session);
            StatisticsImplementor statistics = factory.getStatistics();
            if (statistics.isStatisticsEnabled()) {
                if (cachedResults == null) {
                    statistics.queryCacheMiss(queryIdentifier, queryCache.getRegion().getName());
                } else {
                    statistics.queryCacheHit(queryIdentifier, queryCache.getRegion().getName());
                }
            }
        } else {
            SqlExecLogger.INSTANCE.debugf("Skipping reading Query result cache data: cache-enabled = %s, cache-mode = %s", queryCacheEnabled, cacheMode.name());
            cachedResults = null;
            queryResultsCacheKey = queryCacheEnabled && canBeCached ? QueryKey.from(jdbcSelect.getSql(), executionContext.getQueryOptions().getLimit(), executionContext.getQueryParameterBindings(), session) : null;
        }
        if (cachedResults == null) {
            return new JdbcValuesResultSetImpl(resultSetAccess, queryResultsCacheKey, queryIdentifier, executionContext.getQueryOptions(), jdbcValuesMapping, executionContext);
        }
        return new JdbcValuesCacheHit(cachedResults, jdbcValuesMapping);
    }
}

