/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.caching.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.caching.QueryCachePutManager;
import org.hibernate.stat.spi.StatisticsImplementor;

public class QueryCachePutManagerEnabledImpl
implements QueryCachePutManager {
    private final QueryResultsCache queryCache;
    private final StatisticsImplementor statistics;
    private final QueryKey queryKey;
    private final String queryIdentifier;
    private final List<Object[]> dataToCache = new ArrayList<Object[]>();

    public QueryCachePutManagerEnabledImpl(QueryResultsCache queryCache, StatisticsImplementor statistics, QueryKey queryKey, String queryIdentifier) {
        this.queryCache = queryCache;
        this.statistics = statistics;
        this.queryKey = queryKey;
        this.queryIdentifier = queryIdentifier;
    }

    @Override
    public void registerJdbcRow(Object[] values) {
        this.dataToCache.add(Arrays.copyOf(values, values.length));
    }

    @Override
    public void finishUp(SharedSessionContractImplementor session) {
        boolean put;
        if (this.queryKey != null && (put = this.queryCache.put(this.queryKey, this.dataToCache, session)) && this.statistics.isStatisticsEnabled()) {
            this.statistics.queryCachePut(this.queryIdentifier, this.queryCache.getRegion().getName());
        }
    }
}

