/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.basic;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.UnfetchedBasicPartResultAssembler;
import org.hibernate.sql.results.graph.UnfetchedResultAssembler;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.basic.BasicResultGraphNode;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicFetch<T>
implements Fetch,
BasicResultGraphNode<T> {
    private final NavigablePath navigablePath;
    private final FetchParent fetchParent;
    private final BasicValuedModelPart valuedMapping;
    private final boolean nullable;
    private final DomainResultAssembler<T> assembler;
    private final FetchTiming fetchTiming;

    public BasicFetch(int valuesArrayPosition, FetchParent fetchParent, NavigablePath fetchablePath, BasicValuedModelPart valuedMapping, boolean nullable, BasicValueConverter<T, ?> valueConverter, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        this(valuesArrayPosition, fetchParent, fetchablePath, valuedMapping, nullable, valueConverter, fetchTiming, true, creationState);
    }

    public BasicFetch(int valuesArrayPosition, FetchParent fetchParent, NavigablePath fetchablePath, BasicValuedModelPart valuedMapping, boolean nullable, BasicValueConverter<T, ?> valueConverter, FetchTiming fetchTiming, boolean canBasicPartFetchBeDelayed, DomainResultCreationState creationState) {
        this.nullable = nullable;
        this.navigablePath = fetchablePath;
        this.fetchParent = fetchParent;
        this.valuedMapping = valuedMapping;
        this.fetchTiming = fetchTiming;
        JavaType<?> javaTypeDescriptor = valuedMapping.getJavaTypeDescriptor();
        this.assembler = fetchTiming == FetchTiming.DELAYED && valuesArrayPosition == -1 ? (canBasicPartFetchBeDelayed ? new UnfetchedResultAssembler(javaTypeDescriptor) : new UnfetchedBasicPartResultAssembler(javaTypeDescriptor)) : new BasicResultAssembler(valuesArrayPosition, javaTypeDescriptor, valueConverter);
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    @Override
    public boolean hasTableGroup() {
        return this.fetchTiming == FetchTiming.IMMEDIATE;
    }

    @Override
    public DomainResult<?> asResult(DomainResultCreationState creationState) {
        return this.valuedMapping.createDomainResult(this.navigablePath, ResultsHelper.impl(creationState).getFromClauseAccess().getTableGroup(this.fetchParent.getNavigablePath()), this.getResultVariable(), creationState);
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.valuedMapping;
    }

    @Override
    public JavaType<?> getResultJavaTypeDescriptor() {
        return null;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return this.assembler;
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(AssemblerCreationState creationState) {
        return this.assembler;
    }

    @Override
    public String getResultVariable() {
        return null;
    }
}

