/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.function.Supplier;
import org.hibernate.collection.internal.PersistentArrayHolder;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractCollectionAssembler
implements DomainResultAssembler {
    private final PluralAttributeMapping fetchedMapping;
    protected final CollectionInitializer initializer;

    public AbstractCollectionAssembler(PluralAttributeMapping fetchedMapping, Supplier<CollectionInitializer> initializerProducer) {
        this.fetchedMapping = fetchedMapping;
        this.initializer = initializerProducer.get();
    }

    public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        PersistentCollection collectionInstance = this.initializer.getCollectionInstance();
        if (collectionInstance instanceof PersistentArrayHolder) {
            return collectionInstance.getValue();
        }
        return collectionInstance;
    }

    public JavaType getAssembledJavaTypeDescriptor() {
        return this.fetchedMapping.getJavaTypeDescriptor();
    }
}

