/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;

public abstract class CollectionFetch
implements Fetch {
    private final NavigablePath fetchedPath;
    private final PluralAttributeMapping fetchedAttribute;
    private final FetchParent fetchParent;

    public CollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, FetchParent fetchParent) {
        this.fetchedPath = fetchedPath;
        this.fetchedAttribute = fetchedAttribute;
        this.fetchParent = fetchParent;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public PluralAttributeMapping getFetchedMapping() {
        return this.fetchedAttribute;
    }

    @Override
    public DomainResult<?> asResult(DomainResultCreationState creationState) {
        return this.fetchedAttribute.createDomainResult(this.fetchedPath, ResultsHelper.impl(creationState).getFromClauseAccess().getTableGroup(this.fetchParent.getNavigablePath()), null, creationState);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.fetchedPath;
    }
}

