/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.internal.CollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.SelectEagerCollectionAssembler;
import org.hibernate.type.descriptor.java.JavaType;

public class SelectEagerCollectionFetch
extends CollectionFetch {
    private final DomainResult<?> collectionKeyDomainResult;

    public SelectEagerCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, DomainResult<?> collectionKeyDomainResult, FetchParent fetchParent) {
        super(fetchedPath, fetchedAttribute, fetchParent);
        this.collectionKeyDomainResult = collectionKeyDomainResult;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.DELAYED;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    @Override
    public DomainResultAssembler<?> createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return new SelectEagerCollectionAssembler(this.getNavigablePath(), this.getFetchedMapping(), parentAccess, this.collectionKeyDomainResult == null ? null : this.collectionKeyDomainResult.createResultAssembler(creationState), creationState);
    }

    @Override
    public JavaType<?> getResultJavaTypeDescriptor() {
        return this.getFetchedMapping().getJavaTypeDescriptor();
    }
}

