/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.EntityIdentifierNavigablePath;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractEntityResultGraphNode
extends AbstractFetchParent
implements EntityResultGraphNode {
    private final EntityValuedModelPart referencedModelPart;
    private final DomainResult<?> identifierResult;
    private final BasicFetch<?> discriminatorFetch;
    private final DomainResult<Object> rowIdResult;

    public AbstractEntityResultGraphNode(EntityValuedModelPart referencedModelPart, NavigablePath navigablePath, DomainResultCreationState creationState) {
        super(referencedModelPart.getEntityMappingType(), navigablePath);
        this.referencedModelPart = referencedModelPart;
        EntityMappingType entityDescriptor = referencedModelPart.getEntityMappingType();
        TableGroup entityTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(navigablePath);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        EntityIdentifierNavigablePath identifierNavigablePath = new EntityIdentifierNavigablePath(navigablePath, ResultsHelper.attributeName(identifierMapping));
        if (navigablePath.getParent() == null && !creationState.forceIdentifierSelection()) {
            this.identifierResult = null;
            this.visitIdentifierMapping(identifierNavigablePath, creationState, identifierMapping, entityTableGroup);
        } else {
            this.identifierResult = referencedModelPart instanceof ToOneAttributeMapping ? (((ToOneAttributeMapping)referencedModelPart).canJoinForeignKey(identifierMapping) ? ((ToOneAttributeMapping)referencedModelPart).getForeignKeyDescriptor().createKeyDomainResult(navigablePath, creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(navigablePath.getParent()), creationState) : identifierMapping.createDomainResult(identifierNavigablePath, ((LazyTableGroup)entityTableGroup).getTableGroup(), null, creationState)) : identifierMapping.createDomainResult(identifierNavigablePath, entityTableGroup, null, creationState);
        }
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        this.discriminatorFetch = discriminatorMapping != null && entityDescriptor.hasSubclasses() ? discriminatorMapping.generateFetch(this, navigablePath.append("{discriminator}"), FetchTiming.IMMEDIATE, true, null, creationState) : null;
        EntityRowIdMapping rowIdMapping = entityDescriptor.getRowIdMapping();
        this.rowIdResult = rowIdMapping == null ? null : rowIdMapping.createDomainResult(navigablePath.append(rowIdMapping.getRowIdName()), entityTableGroup, "rowid_", creationState);
    }

    private void visitIdentifierMapping(EntityIdentifierNavigablePath navigablePath, DomainResultCreationState creationState, EntityIdentifierMapping identifierMapping, TableGroup entityTableGroup) {
        MappingType mappingType = identifierMapping.getPartMappingType();
        if (mappingType instanceof ManagedMappingType) {
            ((ManagedMappingType)mappingType).visitAttributeMappings(attributeMapping -> {
                if (attributeMapping instanceof ToOneAttributeMapping) {
                    ((ToOneAttributeMapping)attributeMapping).getForeignKeyDescriptor().createKeyDomainResult(navigablePath.getParent(), entityTableGroup, creationState);
                } else {
                    attributeMapping.createDomainResult(navigablePath, entityTableGroup, null, creationState);
                }
            });
        } else {
            identifierMapping.createDomainResult(navigablePath, entityTableGroup, null, creationState);
        }
    }

    @Override
    public EntityMappingType getReferencedMappingContainer() {
        return this.getEntityValuedModelPart().getEntityMappingType();
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.referencedModelPart;
    }

    @Override
    public JavaType<?> getResultJavaTypeDescriptor() {
        return this.getEntityValuedModelPart().getEntityMappingType().getMappedJavaTypeDescriptor();
    }

    public DomainResult getIdentifierResult() {
        return this.identifierResult;
    }

    public BasicFetch<?> getDiscriminatorFetch() {
        return this.discriminatorFetch;
    }

    public DomainResult<Object> getRowIdResult() {
        return this.rowIdResult;
    }
}

