/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.persistence.Enumerated;
import jakarta.persistence.MapKeyEnumerated;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Nationalized;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.model.convert.internal.NamedEnumValueConverter;
import org.hibernate.metamodel.model.convert.internal.OrdinalEnumValueConverter;
import org.hibernate.metamodel.model.convert.spi.EnumValueConverter;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.jboss.logging.Logger;

public class EnumType<T extends Enum<T>>
implements EnhancedUserType,
DynamicParameterizedType,
LoggableUserType,
TypeConfigurationAware,
Serializable {
    private static final Logger LOG = CoreLogging.logger(EnumType.class);
    public static final String ENUM = "enumClass";
    public static final String NAMED = "useNamed";
    public static final String TYPE = "type";
    private Class<T> enumClass;
    private EnumValueConverter<T, Object> enumValueConverter;
    private JdbcType jdbcType;
    private ValueExtractor<T> jdbcValueExtractor;
    private ValueBinder<T> jdbcValueBinder;
    private TypeConfiguration typeConfiguration;

    public EnumType() {
    }

    public EnumType(Class<T> enumClass, EnumValueConverter enumValueConverter, TypeConfiguration typeConfiguration) {
        this.enumClass = enumClass;
        this.typeConfiguration = typeConfiguration;
        this.enumValueConverter = enumValueConverter;
        this.jdbcType = typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(enumValueConverter.getJdbcTypeCode());
        this.jdbcValueExtractor = this.jdbcType.getExtractor(enumValueConverter.getRelationalJavaDescriptor());
        this.jdbcValueBinder = this.jdbcType.getBinder(enumValueConverter.getRelationalJavaDescriptor());
    }

    public EnumValueConverter getEnumValueConverter() {
        return this.enumValueConverter;
    }

    @Override
    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        if (reader != null) {
            boolean isOrdinal;
            this.enumClass = reader.getReturnedClass().asSubclass(Enum.class);
            Long columnLength = reader.getColumnLengths()[0];
            jakarta.persistence.EnumType enumType = this.getEnumType(reader);
            if (enumType == null) {
                isOrdinal = true;
            } else if (jakarta.persistence.EnumType.ORDINAL.equals((Object)enumType)) {
                isOrdinal = true;
            } else if (jakarta.persistence.EnumType.STRING.equals((Object)enumType)) {
                isOrdinal = false;
            } else {
                throw new AssertionFailure("Unknown EnumType: " + enumType);
            }
            EnumJavaTypeDescriptor enumJavaDescriptor = (EnumJavaTypeDescriptor)this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(this.enumClass);
            LocalJdbcTypeDescriptorIndicators indicators = new LocalJdbcTypeDescriptorIndicators(enumType, columnLength, reader);
            BasicJavaType<Integer> relationalJtd = this.resolveRelationalJavaTypeDescriptor(indicators, enumJavaDescriptor);
            JdbcType jdbcType = relationalJtd.getRecommendedJdbcType(indicators);
            this.enumValueConverter = isOrdinal ? new OrdinalEnumValueConverter<T>(enumJavaDescriptor, jdbcType, relationalJtd) : new NamedEnumValueConverter<T>(enumJavaDescriptor, jdbcType, relationalJtd);
            this.jdbcType = jdbcType;
        } else {
            String enumClassName = (String)parameters.get(ENUM);
            try {
                this.enumClass = ReflectHelper.classForName(enumClassName, this.getClass()).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException exception) {
                throw new HibernateException("Enum class not found: " + enumClassName, exception);
            }
            this.enumValueConverter = this.interpretParameters(parameters);
            this.jdbcType = this.typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(this.enumValueConverter.getJdbcTypeCode());
        }
        this.jdbcValueExtractor = this.jdbcType.getExtractor(this.enumValueConverter.getRelationalJavaDescriptor());
        this.jdbcValueBinder = this.jdbcType.getBinder(this.enumValueConverter.getRelationalJavaDescriptor());
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Using %s-based conversion for Enum %s", (Object)(this.isOrdinal() ? "ORDINAL" : "NAMED"), (Object)this.enumClass.getName());
        }
    }

    private BasicJavaType<?> resolveRelationalJavaTypeDescriptor(LocalJdbcTypeDescriptorIndicators indicators, EnumJavaTypeDescriptor<?> enumJavaDescriptor) {
        return enumJavaDescriptor.getRecommendedJdbcType(indicators).getJdbcRecommendedJavaTypeMapping(null, null, this.typeConfiguration);
    }

    private jakarta.persistence.EnumType getEnumType(DynamicParameterizedType.ParameterType reader) {
        MapKeyEnumerated enumAnn;
        if (reader == null) {
            return null;
        }
        if (reader.isPrimaryKey() && (enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), MapKeyEnumerated.class)) != null) {
            return enumAnn.value();
        }
        enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), Enumerated.class);
        if (enumAnn != null) {
            return enumAnn.value();
        }
        return null;
    }

    private <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> anClass) {
        for (Annotation annotation : annotations) {
            if (!anClass.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    private EnumValueConverter<T, Object> interpretParameters(Properties parameters) {
        EnumJavaTypeDescriptor enumJavaDescriptor = (EnumJavaTypeDescriptor)this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(this.enumClass);
        assert (parameters.get("org.hibernate.type.ParameterType") == null);
        LocalJdbcTypeDescriptorIndicators localIndicators = new LocalJdbcTypeDescriptorIndicators(jakarta.persistence.EnumType.ORDINAL, -1L, null);
        BasicJavaType stringJavaDescriptor = (BasicJavaType)this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)String.class));
        BasicJavaType integerJavaDescriptor = (BasicJavaType)this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Integer.class));
        if (parameters.containsKey(NAMED)) {
            boolean useNamed = ConfigurationHelper.getBoolean(NAMED, parameters);
            if (useNamed) {
                return new NamedEnumValueConverter(enumJavaDescriptor, stringJavaDescriptor.getRecommendedJdbcType(localIndicators), stringJavaDescriptor);
            }
            return new OrdinalEnumValueConverter(enumJavaDescriptor, integerJavaDescriptor.getRecommendedJdbcType(localIndicators), this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Integer.class)));
        }
        if (parameters.containsKey(TYPE)) {
            int type = Integer.decode((String)parameters.get(TYPE));
            if (this.isNumericType(type)) {
                return new OrdinalEnumValueConverter(enumJavaDescriptor, integerJavaDescriptor.getRecommendedJdbcType(localIndicators), this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Integer.class)));
            }
            if (this.isCharacterType(type)) {
                return new NamedEnumValueConverter(enumJavaDescriptor, stringJavaDescriptor.getRecommendedJdbcType(localIndicators), stringJavaDescriptor);
            }
            throw new HibernateException(String.format(Locale.ENGLISH, "Passed JDBC type code [%s] not recognized as numeric nor character", type));
        }
        return new OrdinalEnumValueConverter(enumJavaDescriptor, integerJavaDescriptor.getRecommendedJdbcType(localIndicators), this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Integer.class)));
    }

    private boolean isCharacterType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isNumericType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] sqlTypes() {
        this.verifyConfigured();
        return new int[]{this.enumValueConverter.getJdbcTypeCode()};
    }

    public Class<? extends Enum> returnedClass() {
        return this.enumClass;
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    @Override
    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        this.verifyConfigured();
        T relational = this.jdbcValueExtractor.extract(rs, position, (WrapperOptions)session);
        return this.enumValueConverter.toDomainValue(relational);
    }

    private void verifyConfigured() {
        if (this.enumValueConverter == null || this.jdbcValueBinder == null || this.jdbcValueExtractor == null) {
            throw new AssertionFailure("EnumType (" + this.enumClass.getName() + ") not properly, fully configured");
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.verifyConfigured();
        this.enumValueConverter.writeValue(st, (Enum)value, index, session);
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    @Override
    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    @Override
    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public void setTypeConfiguration(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    @Override
    public String objectToSQLString(Object value) {
        this.verifyConfigured();
        return this.enumValueConverter.toSqlLiteral(value);
    }

    @Override
    public String toXMLString(Object value) {
        this.verifyConfigured();
        return ((EnumJavaTypeDescriptor)this.enumValueConverter.getDomainJavaDescriptor()).unwrap((Enum)value, String.class, null);
    }

    @Override
    public Object fromXMLString(CharSequence xmlValue) {
        this.verifyConfigured();
        return ((EnumJavaTypeDescriptor)this.enumValueConverter.getDomainJavaDescriptor()).wrap(xmlValue, (WrapperOptions)null);
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        this.verifyConfigured();
        return ((EnumJavaTypeDescriptor)this.enumValueConverter.getDomainJavaDescriptor()).toString((Enum)value);
    }

    public boolean isOrdinal() {
        this.verifyConfigured();
        return this.enumValueConverter instanceof OrdinalEnumValueConverter;
    }

    private class LocalJdbcTypeDescriptorIndicators
    implements JdbcTypeDescriptorIndicators {
        private final jakarta.persistence.EnumType enumType;
        private final Long columnLength;
        private final DynamicParameterizedType.ParameterType reader;

        public LocalJdbcTypeDescriptorIndicators(jakarta.persistence.EnumType enumType2, Long columnLength, DynamicParameterizedType.ParameterType reader) {
            this.enumType = enumType2;
            this.columnLength = columnLength;
            this.reader = reader;
        }

        @Override
        public TypeConfiguration getTypeConfiguration() {
            return EnumType.this.typeConfiguration;
        }

        @Override
        public jakarta.persistence.EnumType getEnumeratedType() {
            if (this.enumType != null) {
                return this.enumType;
            }
            return EnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getEnumeratedType();
        }

        @Override
        public boolean isNationalized() {
            return this.isNationalized(this.reader);
        }

        private boolean isNationalized(DynamicParameterizedType.ParameterType reader) {
            if (EnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().isNationalized()) {
                return true;
            }
            if (reader != null) {
                for (Annotation annotation : reader.getAnnotationsMethod()) {
                    if (!(annotation instanceof Nationalized)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public long getColumnLength() {
            return this.columnLength == null ? -1L : this.columnLength;
        }
    }
}

