/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.CoercionHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class BigDecimalJavaTypeDescriptor
extends AbstractClassJavaTypeDescriptor<BigDecimal> {
    public static final BigDecimalJavaTypeDescriptor INSTANCE = new BigDecimalJavaTypeDescriptor();

    public BigDecimalJavaTypeDescriptor() {
        super(BigDecimal.class);
    }

    @Override
    public String toString(BigDecimal value) {
        return value.toString();
    }

    @Override
    public BigDecimal fromString(CharSequence string) {
        return new BigDecimal(string.toString());
    }

    @Override
    public boolean areEqual(BigDecimal one, BigDecimal another) {
        return one == another || one != null && another != null && one.compareTo(another) == 0;
    }

    @Override
    public int extractHashCode(BigDecimal value) {
        return value.intValue();
    }

    @Override
    public <X> X unwrap(BigDecimal value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return (X)value.toBigIntegerExact();
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)Byte.valueOf(value.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)Short.valueOf(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return (X)Double.valueOf(value.doubleValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return (X)Float.valueOf(value.floatValue());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> BigDecimal wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)value).doubleValue());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return this.getDefaultSqlPrecision(dialect) + 2;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect) {
        return dialect.getDefaultDecimalPrecision();
    }

    @Override
    public <X> BigDecimal coerce(X value, JavaType.CoercionContext coercionContext) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return CoercionHelper.coerceWrappingError(() -> BigDecimal.valueOf(Double.parseDouble((String)value)));
        }
        throw new CoercionException(String.format(Locale.ROOT, "Unable to coerce value [%s (%s)] to BigDecimal", value, value.getClass().getName()));
    }
}

