/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Objects;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public interface JavaType<T>
extends Serializable {
    default public Type getJavaType() {
        return this.getJavaTypeClass();
    }

    default public MutabilityPlan<T> getMutabilityPlan() {
        return ImmutableMutabilityPlan.INSTANCE;
    }

    default public T getReplacement(T original, T target, SharedSessionContractImplementor session) {
        if (!this.getMutabilityPlan().isMutable() || target != null && this.areEqual(original, target)) {
            return original;
        }
        return this.getMutabilityPlan().deepCopy(original);
    }

    public JdbcType getRecommendedJdbcType(JdbcTypeDescriptorIndicators var1);

    default public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 255L;
    }

    default public long getLongSqlLength() {
        return 65535L;
    }

    default public int getDefaultSqlPrecision(Dialect dialect) {
        return 19;
    }

    default public int getDefaultSqlScale() {
        return 2;
    }

    default public Comparator<T> getComparator() {
        return Comparable.class.isAssignableFrom(this.getJavaTypeClass()) ? ComparableComparator.INSTANCE : null;
    }

    default public int extractHashCode(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Value to extract hashCode from cannot be null");
        }
        return value.hashCode();
    }

    default public boolean areEqual(T one, T another) {
        return Objects.deepEquals(one, another);
    }

    default public String extractLoggableRepresentation(T value) {
        return this.toString(value);
    }

    default public String toString(T value) {
        return value == null ? "null" : value.toString();
    }

    public T fromString(CharSequence var1);

    public <X> X unwrap(T var1, Class<X> var2, WrapperOptions var3);

    public <X> T wrap(X var1, WrapperOptions var2);

    default public <X> T coerce(X value, CoercionContext coercionContext) {
        return (T)value;
    }

    default public Class<T> getJavaTypeClass() {
        return ReflectHelper.getClass(this.getJavaType());
    }

    default public String getCheckCondition(String columnName, JdbcType sqlType, Dialect dialect) {
        return null;
    }

    public static interface CoercionContext {
        public TypeConfiguration getTypeConfiguration();
    }
}

