/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcDateJavaTypeDescriptor
extends AbstractTemporalJavaTypeDescriptor<java.util.Date> {
    public static final JdbcDateJavaTypeDescriptor INSTANCE = new JdbcDateJavaTypeDescriptor();
    public static final String DATE_FORMAT = "dd MMMM yyyy";
    public static final DateTimeFormatter LITERAL_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final DateTimeFormatter LOGGABLE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;

    public JdbcDateJavaTypeDescriptor() {
        super(java.util.Date.class, DateMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.DATE;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeDescriptorIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeDescriptorRegistry().getDescriptor(91);
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(java.util.Date value) {
        return LOGGABLE_FORMATTER.format(value.toInstant());
    }

    @Override
    public java.util.Date fromString(CharSequence string) {
        try {
            return new java.util.Date(new SimpleDateFormat(DATE_FORMAT).parse(string.toString()).getTime());
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse date string" + string, pe);
        }
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (one.getTime() == another.getTime()) {
            return true;
        }
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(one);
        calendar2.setTime(another);
        return calendar1.get(2) == calendar2.get(2) && calendar1.get(5) == calendar2.get(5) && calendar1.get(1) == calendar2.get(1);
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        int hashCode = 1;
        hashCode = 31 * hashCode + calendar.get(2);
        hashCode = 31 * hashCode + calendar.get(5);
        hashCode = 31 * hashCode + calendar.get(1);
        return hashCode;
    }

    @Override
    public <X> X unwrap(java.util.Date value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(type)) {
            Date rtn = value instanceof Date ? (Date)value : new Date(value.getTime());
            return (X)rtn;
        }
        if (Time.class.isAssignableFrom(type)) {
            Time rtn = value instanceof Time ? (Time)value : new Time(value.getTime());
            return (X)rtn;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            Timestamp rtn = value instanceof Timestamp ? (Timestamp)value : new Timestamp(value.getTime());
            return (X)rtn;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return (X)cal;
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.getTime());
        }
        if (LocalDate.class.isAssignableFrom(type) && value instanceof Date) {
            return (X)((Date)value).toLocalDate();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> java.util.Date wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class DateMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final DateMutabilityPlan INSTANCE = new DateMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            return value instanceof Date ? new Date(value.getTime()) : new java.util.Date(value.getTime());
        }
    }
}

