/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.net.MalformedURLException;
import java.net.URL;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;

public class UrlJavaTypeDescriptor
extends AbstractClassJavaTypeDescriptor<URL> {
    public static final UrlJavaTypeDescriptor INSTANCE = new UrlJavaTypeDescriptor();

    public UrlJavaTypeDescriptor() {
        super(URL.class);
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeDescriptorIndicators context) {
        return VarcharJdbcType.INSTANCE;
    }

    @Override
    public String toString(URL value) {
        return value.toExternalForm();
    }

    @Override
    public URL fromString(CharSequence string) {
        try {
            return new URL(string.toString());
        }
        catch (MalformedURLException e) {
            throw new HibernateException("Unable to convert string [" + string + "] to URL : " + e);
        }
    }

    @Override
    public <X> X unwrap(URL value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> URL wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (CharSequence.class.isInstance(value)) {
            return this.fromString((CharSequence)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

