/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.DynamicModelJtd;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorBaseline;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorBasicAdaptor;
import org.hibernate.type.descriptor.java.spi.RegistryHelper;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.jboss.logging.Logger;

public class JavaTypeDescriptorRegistry
implements JavaTypeDescriptorBaseline.BaselineTarget,
Serializable {
    private static final Logger log = Logger.getLogger(JavaTypeDescriptorRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final ConcurrentHashMap<Type, JavaType<?>> descriptorsByType = new ConcurrentHashMap();

    public JavaTypeDescriptorRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        JavaTypeDescriptorBaseline.prime(this);
    }

    @Override
    public void addBaselineDescriptor(JavaType<?> descriptor) {
        if (descriptor.getJavaType() == null) {
            throw new IllegalStateException("Illegal to add BasicJavaTypeDescriptor with null Java type");
        }
        this.addBaselineDescriptor(descriptor.getJavaType(), descriptor);
    }

    @Override
    public void addBaselineDescriptor(Type describedJavaType, JavaType<?> descriptor) {
        this.performInjections(descriptor);
        this.descriptorsByType.put(describedJavaType, descriptor);
    }

    private void performInjections(JavaType<?> descriptor) {
        if (descriptor instanceof TypeConfigurationAware) {
            ((TypeConfigurationAware)((Object)descriptor)).setTypeConfiguration(this.typeConfiguration);
        }
    }

    public <T> JavaType<T> getDescriptor(Type javaType) {
        return this.resolveDescriptor(javaType);
    }

    public void addDescriptor(JavaType<?> descriptor) {
        JavaType<?> old = this.descriptorsByType.put(descriptor.getJavaType(), descriptor);
        if (old != null) {
            log.debugf("JavaTypeDescriptorRegistry entry replaced : %s -> %s (was %s)", (Object)descriptor.getJavaType(), descriptor, old);
        }
        this.performInjections(descriptor);
    }

    public <J> JavaType<J> resolveDescriptor(Type javaType, Supplier<JavaType<J>> creator) {
        JavaType<?> cached = this.descriptorsByType.get(javaType);
        if (cached != null) {
            return cached;
        }
        JavaType<J> created = creator.get();
        this.descriptorsByType.put(javaType, created);
        return created;
    }

    public <J> JavaType<J> resolveDescriptor(Type javaType) {
        return this.resolveDescriptor(javaType, () -> {
            Class javaTypeClass;
            if (javaType instanceof Class) {
                javaTypeClass = (Class)javaType;
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)javaType;
                javaTypeClass = (Class)parameterizedType.getRawType();
            }
            return RegistryHelper.INSTANCE.createTypeDescriptor(javaTypeClass, () -> {
                MutabilityPlan determinedPlan = RegistryHelper.INSTANCE.determineMutabilityPlan(javaType, this.typeConfiguration);
                if (determinedPlan != null) {
                    return determinedPlan;
                }
                return new MutableMutabilityPlan<J>(){

                    @Override
                    protected J deepCopyNotNull(J value) {
                        return value;
                    }
                };
            }, this.typeConfiguration);
        });
    }

    public <J> JavaType<J> resolveManagedTypeDescriptor(Type javaType) {
        return this.resolveDescriptor(javaType, () -> {
            Class javaTypeClass;
            if (javaType instanceof Class) {
                javaTypeClass = (Class)javaType;
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)javaType;
                javaTypeClass = (Class)parameterizedType.getRawType();
            }
            MutableMutabilityPlan determinedPlan = RegistryHelper.INSTANCE.determineMutabilityPlan(javaType, this.typeConfiguration);
            MutableMutabilityPlan mutabilityPlan = determinedPlan != null ? determinedPlan : new MutableMutabilityPlan<J>(){

                @Override
                protected J deepCopyNotNull(J value) {
                    return value;
                }
            };
            return new JavaTypeDescriptorBasicAdaptor(javaTypeClass, mutabilityPlan);
        });
    }

    public JavaType<?> resolveDynamicEntityDescriptor(String typeName) {
        return new DynamicModelJtd();
    }
}

