/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.type.descriptor.JdbcBindingLogging;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public abstract class BasicBinder<J>
implements ValueBinder<J>,
Serializable {
    private static final String BIND_MSG_TEMPLATE = "binding parameter [%s] as [%s] - [%s]";
    private static final String NULL_BIND_MSG_TEMPLATE = "binding parameter [%s] as [%s] - [null]";
    private final JavaType<J> javaDescriptor;
    private final JdbcType jdbcType;

    public JavaType<J> getJavaTypeDescriptor() {
        return this.javaDescriptor;
    }

    public JdbcType getJdbcTypeDescriptor() {
        return this.jdbcType;
    }

    public BasicBinder(JavaType<J> javaDescriptor, JdbcType jdbcType) {
        this.javaDescriptor = javaDescriptor;
        this.jdbcType = jdbcType;
    }

    @Override
    public final void bind(PreparedStatement st, J value, int index, WrapperOptions options) throws SQLException {
        if (value == null) {
            if (JdbcBindingLogging.TRACE_ENABLED) {
                JdbcBindingLogging.LOGGER.trace((Object)String.format(NULL_BIND_MSG_TEMPLATE, index, JdbcTypeNameMapper.getTypeName(this.getJdbcTypeDescriptor().getJdbcTypeCode())));
            }
            this.doBindNull(st, index, options);
        } else {
            if (JdbcBindingLogging.TRACE_ENABLED) {
                JdbcBindingLogging.LOGGER.trace((Object)String.format(BIND_MSG_TEMPLATE, index, JdbcTypeNameMapper.getTypeName(this.jdbcType.getJdbcTypeCode()), this.getJavaTypeDescriptor().extractLoggableRepresentation(value)));
            }
            this.doBind(st, value, index, options);
        }
    }

    @Override
    public final void bind(CallableStatement st, J value, String name, WrapperOptions options) throws SQLException {
        if (value == null) {
            if (JdbcBindingLogging.TRACE_ENABLED) {
                JdbcBindingLogging.LOGGER.trace((Object)String.format(NULL_BIND_MSG_TEMPLATE, name, JdbcTypeNameMapper.getTypeName(this.getJdbcTypeDescriptor().getJdbcTypeCode())));
            }
            this.doBindNull(st, name, options);
        } else {
            if (JdbcBindingLogging.TRACE_ENABLED) {
                JdbcBindingLogging.LOGGER.trace((Object)String.format(BIND_MSG_TEMPLATE, name, JdbcTypeNameMapper.getTypeName(this.jdbcType.getJdbcTypeCode()), this.getJavaTypeDescriptor().extractLoggableRepresentation(value)));
            }
            this.doBind(st, value, name, options);
        }
    }

    protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
        st.setNull(index, this.jdbcType.getJdbcTypeCode());
    }

    protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
        st.setNull(name, this.jdbcType.getJdbcTypeCode());
    }

    protected abstract void doBind(PreparedStatement var1, J var2, int var3, WrapperOptions var4) throws SQLException;

    protected abstract void doBind(CallableStatement var1, J var2, String var3, WrapperOptions var4) throws SQLException;
}

