/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.JdbcExtractingLogging;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public abstract class BasicExtractor<J>
implements ValueExtractor<J>,
Serializable {
    private final JavaType<J> javaTypeDescriptor;
    private final JdbcType jdbcType;

    public BasicExtractor(JavaType<J> javaTypeDescriptor, JdbcType jdbcType) {
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.jdbcType = jdbcType;
    }

    public JavaType<J> getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public JdbcType getJdbcTypeDescriptor() {
        return this.jdbcType;
    }

    @Override
    public J extract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
        J value = this.doExtract(rs, paramIndex, options);
        if (value == null || rs.wasNull()) {
            if (JdbcExtractingLogging.TRACE_ENABLED) {
                JdbcExtractingLogging.LOGGER.tracef("extracted value ([%s] : [%s]) - [null]", paramIndex, (Object)JdbcTypeNameMapper.getTypeName(this.getJdbcTypeDescriptor().getJdbcTypeCode()));
            }
            return null;
        }
        if (JdbcExtractingLogging.TRACE_ENABLED) {
            JdbcExtractingLogging.LOGGER.tracef("extracted value ([%s] : [%s]) - [%s]", paramIndex, (Object)JdbcTypeNameMapper.getTypeName(this.getJdbcTypeDescriptor().getJdbcTypeCode()), (Object)this.getJavaTypeDescriptor().extractLoggableRepresentation(value));
        }
        return value;
    }

    protected abstract J doExtract(ResultSet var1, int var2, WrapperOptions var3) throws SQLException;

    @Override
    public J extract(CallableStatement statement, int paramIndex, WrapperOptions options) throws SQLException {
        J value = this.doExtract(statement, paramIndex, options);
        if (value == null || statement.wasNull()) {
            if (JdbcExtractingLogging.TRACE_ENABLED) {
                JdbcExtractingLogging.LOGGER.tracef("extracted procedure output  parameter ([%s] : [%s]) - [null]", paramIndex, (Object)JdbcTypeNameMapper.getTypeName(this.getJdbcTypeDescriptor().getJdbcTypeCode()));
            }
            return null;
        }
        if (JdbcExtractingLogging.TRACE_ENABLED) {
            JdbcExtractingLogging.LOGGER.tracef("extracted procedure output  parameter ([%s] : [%s]) - [%s]", paramIndex, (Object)JdbcTypeNameMapper.getTypeName(this.getJdbcTypeDescriptor().getJdbcTypeCode()), (Object)this.getJavaTypeDescriptor().extractLoggableRepresentation(value));
        }
        return value;
    }

    protected abstract J doExtract(CallableStatement var1, int var2, WrapperOptions var3) throws SQLException;

    @Override
    public J extract(CallableStatement statement, String paramName, WrapperOptions options) throws SQLException {
        J value = this.doExtract(statement, paramName, options);
        if (value == null || statement.wasNull()) {
            if (JdbcExtractingLogging.TRACE_ENABLED) {
                JdbcExtractingLogging.LOGGER.tracef("extracted named procedure output  parameter ([%s] : [%s]) - [null]", (Object)paramName, (Object)JdbcTypeNameMapper.getTypeName(this.getJdbcTypeDescriptor().getJdbcTypeCode()));
            }
            return null;
        }
        if (JdbcExtractingLogging.TRACE_ENABLED) {
            JdbcExtractingLogging.LOGGER.tracef("extracted named procedure output  parameter ([%s] : [%s]) - [%s]", (Object)paramName, (Object)JdbcTypeNameMapper.getTypeName(this.getJdbcTypeDescriptor().getJdbcTypeCode()), (Object)this.getJavaTypeDescriptor().extractLoggableRepresentation(value));
        }
        return value;
    }

    protected abstract J doExtract(CallableStatement var1, String var2, WrapperOptions var3) throws SQLException;
}

