/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class ClobJdbcType
implements AdjustableJdbcType {
    public static final ClobJdbcType DEFAULT = new ClobJdbcType(){

        @Override
        public String toString() {
            return "ClobTypeDescriptor(DEFAULT)";
        }

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaType<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    if (options.useStreamForLobBinding()) {
                        STREAM_BINDING.getClobBinder(javaTypeDescriptor).doBind(st, value, index, options);
                    } else {
                        CLOB_BINDING.getClobBinder(javaTypeDescriptor).doBind(st, value, index, options);
                    }
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    if (options.useStreamForLobBinding()) {
                        STREAM_BINDING.getClobBinder(javaTypeDescriptor).doBind(st, value, name, options);
                    } else {
                        CLOB_BINDING.getClobBinder(javaTypeDescriptor).doBind(st, value, name, options);
                    }
                }
            };
        }
    };
    public static final ClobJdbcType STRING_BINDING = new ClobJdbcType(){

        @Override
        public String toString() {
            return "ClobTypeDescriptor(STRING_BINDING)";
        }

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaType<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setString(index, javaTypeDescriptor.unwrap(value, String.class, options));
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    st.setString(name, javaTypeDescriptor.unwrap(value, String.class, options));
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(rs.getString(paramIndex), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getString(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getString(name), options);
                }
            };
        }
    };
    public static final ClobJdbcType CLOB_BINDING = new ClobJdbcType(){

        @Override
        public String toString() {
            return "ClobTypeDescriptor(CLOB_BINDING)";
        }

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaType<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setClob(index, javaTypeDescriptor.unwrap(value, Clob.class, options));
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    st.setClob(name, javaTypeDescriptor.unwrap(value, Clob.class, options));
                }
            };
        }
    };
    public static final ClobJdbcType STREAM_BINDING = new ClobJdbcType(){

        @Override
        public String toString() {
            return "ClobTypeDescriptor(STREAM_BINDING)";
        }

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaType<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, options);
                    st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, options);
                    st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                }
            };
        }
    };
    public static final ClobJdbcType STREAM_BINDING_EXTRACTING = new ClobJdbcType(){

        @Override
        public String toString() {
            return "ClobTypeDescriptor(STREAM_BINDING_EXTRACTING)";
        }

        @Override
        public <X> BasicBinder<X> getClobBinder(final JavaType<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, options);
                    st.setCharacterStream(index, characterStream.asReader(), characterStream.getLength());
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    CharacterStream characterStream = javaTypeDescriptor.unwrap(value, CharacterStream.class, options);
                    st.setCharacterStream(name, characterStream.asReader(), characterStream.getLength());
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(rs.getCharacterStream(paramIndex), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getCharacterStream(index), options);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getCharacterStream(name), options);
                }
            };
        }
    };

    @Override
    public int getJdbcTypeCode() {
        return 2005;
    }

    @Override
    public String getFriendlyName() {
        return "CLOB";
    }

    public String toString() {
        return "ClobTypeDescriptor";
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeDescriptorIndicators indicators, JavaType<?> domainJtd) {
        TypeConfiguration typeConfiguration = indicators.getTypeConfiguration();
        JdbcTypeDescriptorRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeDescriptorRegistry();
        return indicators.isNationalized() ? jdbcTypeRegistry.getDescriptor(2011) : jdbcTypeRegistry.getDescriptor(2005);
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(rs.getClob(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getClob(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(statement.getClob(name), options);
            }
        };
    }

    protected abstract <X> BasicBinder<X> getClobBinder(JavaType<X> var1);

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return this.getClobBinder(javaTypeDescriptor);
    }
}

