/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import jakarta.persistence.EnumType;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.model.convert.internal.NamedEnumValueConverter;
import org.hibernate.metamodel.model.convert.internal.OrdinalEnumValueConverter;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.SerializableJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class InferredBasicValueResolver {
    public static BasicValue.Resolution from(Function<TypeConfiguration, BasicJavaType> explicitJavaTypeAccess, Function<TypeConfiguration, JdbcType> explicitSqlTypeAccess, Type resolvedJavaType, Supplier<JavaType> reflectedJtdResolver, JdbcTypeDescriptorIndicators stdIndicators, Table table, Selectable selectable, String ownerName, String propertyName, TypeConfiguration typeConfiguration) {
        BasicType<Object> legacyType;
        BasicType<Object> jdbcMapping;
        BasicJavaType explicitJavaType = explicitJavaTypeAccess != null ? explicitJavaTypeAccess.apply(typeConfiguration) : null;
        JdbcType explicitJdbcType = explicitSqlTypeAccess != null ? explicitSqlTypeAccess.apply(typeConfiguration) : null;
        BasicJavaType reflectedJtd = (BasicJavaType)reflectedJtdResolver.get();
        if (explicitJavaType != null) {
            if (explicitJdbcType != null) {
                legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, explicitJdbcType);
            } else {
                JdbcType inferredJdbcType = explicitJavaType.getRecommendedJdbcType(stdIndicators);
                if (inferredJdbcType instanceof ObjectJdbcType) {
                    if (explicitJavaType instanceof EnumJavaTypeDescriptor) {
                        return InferredBasicValueResolver.fromEnum((EnumJavaTypeDescriptor)reflectedJtd, explicitJavaType, null, stdIndicators, typeConfiguration);
                    }
                    if (explicitJavaType instanceof TemporalJavaTypeDescriptor) {
                        return InferredBasicValueResolver.fromTemporal((TemporalJavaTypeDescriptor)reflectedJtd, explicitJavaType, null, resolvedJavaType, stdIndicators, typeConfiguration);
                    }
                    if (explicitJavaType instanceof SerializableJavaTypeDescriptor || explicitJavaType.getJavaType() instanceof Serializable) {
                        jdbcMapping = legacyType = new SerializableType(explicitJavaType);
                    } else {
                        legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, inferredJdbcType);
                    }
                } else {
                    legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, inferredJdbcType);
                }
            }
        } else if (reflectedJtd != null) {
            if (explicitJdbcType != null) {
                legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, explicitJdbcType);
            } else {
                if (reflectedJtd instanceof EnumJavaTypeDescriptor) {
                    return InferredBasicValueResolver.fromEnum((EnumJavaTypeDescriptor)reflectedJtd, null, null, stdIndicators, typeConfiguration);
                }
                if (reflectedJtd instanceof TemporalJavaTypeDescriptor) {
                    return InferredBasicValueResolver.fromTemporal((TemporalJavaTypeDescriptor)reflectedJtd, null, null, resolvedJavaType, stdIndicators, typeConfiguration);
                }
                BasicType registeredType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(reflectedJtd.getJavaType());
                if (registeredType != null) {
                    jdbcMapping = legacyType = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, registeredType, reflectedJtd);
                } else {
                    JdbcType recommendedJdbcType = reflectedJtd.getRecommendedJdbcType(stdIndicators);
                    if (recommendedJdbcType != null) {
                        legacyType = jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, recommendedJdbcType);
                    } else if (reflectedJtd instanceof SerializableJavaTypeDescriptor || reflectedJtd.getJavaType() instanceof Serializable) {
                        jdbcMapping = legacyType = new SerializableType(reflectedJtd);
                    } else {
                        legacyType = null;
                        jdbcMapping = null;
                    }
                }
            }
        } else if (explicitJdbcType != null) {
            Integer length = null;
            Integer scale = null;
            if (selectable instanceof Column) {
                Column column = (Column)selectable;
                if (column.getPrecision() != null && column.getPrecision() > 0) {
                    length = column.getPrecision();
                    scale = column.getScale();
                } else if (column.getLength() != null) {
                    length = column.getLength() > Integer.MAX_VALUE ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(column.getLength().intValue());
                }
            }
            BasicJavaType recommendedJtd = explicitJdbcType.getJdbcRecommendedJavaTypeMapping(length, scale, typeConfiguration);
            BasicType resolved = typeConfiguration.getBasicTypeRegistry().resolve(recommendedJtd, explicitJdbcType);
            legacyType = jdbcMapping = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, resolved, recommendedJtd);
        } else {
            throw new MappingException("Could not determine JavaTypeDescriptor nor SqlTypeDescriptor to use for BasicValue: owner = " + ownerName + "; property = " + propertyName + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        if (jdbcMapping == null) {
            throw new MappingException("Could not determine JavaTypeDescriptor nor SqlTypeDescriptor to use for " + ((BasicValue)stdIndicators).getResolvedJavaType() + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        return new InferredBasicValueResolution(jdbcMapping, jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJdbcTypeDescriptor(), null, legacyType, null);
    }

    public static BasicType<?> resolveSqlTypeIndicators(JdbcTypeDescriptorIndicators stdIndicators, BasicType<?> resolved, JavaType<?> domainJtd) {
        if (resolved instanceof AdjustableBasicType) {
            AdjustableBasicType indicatorCapable = (AdjustableBasicType)resolved;
            BasicType<?> indicatedType = indicatorCapable.resolveIndicatedType(stdIndicators, domainJtd);
            return indicatedType != null ? indicatedType : resolved;
        }
        return resolved;
    }

    public static <E extends Enum<E>> InferredBasicValueResolution fromEnum(EnumJavaTypeDescriptor<E> enumJavaDescriptor, BasicJavaType explicitJavaType, JdbcType explicitJdbcType, JdbcTypeDescriptorIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        EnumType enumStyle = stdIndicators.getEnumeratedType() != null ? stdIndicators.getEnumeratedType() : EnumType.ORDINAL;
        switch (enumStyle) {
            case STRING: {
                JavaType relationalJtd;
                if (explicitJavaType != null) {
                    if (!String.class.isAssignableFrom(explicitJavaType.getJavaTypeClass())) {
                        throw new MappingException("Explicit JavaTypeDescriptor [" + explicitJavaType + "] applied to enumerated value with EnumType#STRING should handle `java.lang.String` as its relational type descriptor");
                    }
                    relationalJtd = explicitJavaType;
                } else {
                    boolean useCharacter = stdIndicators.getColumnLength() == 1L;
                    Class relationalJavaType = useCharacter ? Character.class : String.class;
                    relationalJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)relationalJavaType));
                }
                JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : relationalJtd.getRecommendedJdbcType(stdIndicators);
                NamedEnumValueConverter<E> valueConverter = new NamedEnumValueConverter<E>(enumJavaDescriptor, jdbcType, relationalJtd);
                org.hibernate.type.EnumType legacyEnumType = new org.hibernate.type.EnumType(enumJavaDescriptor.getJavaTypeClass(), valueConverter, typeConfiguration);
                CustomType legacyEnumTypeWrapper = new CustomType(legacyEnumType, typeConfiguration);
                BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, jdbcType);
                return new InferredBasicValueResolution<E>(jdbcMapping, enumJavaDescriptor, relationalJtd, jdbcType, valueConverter, legacyEnumTypeWrapper, ImmutableMutabilityPlan.INSTANCE);
            }
            case ORDINAL: {
                BasicJavaType relationalJtd;
                if (explicitJavaType != null) {
                    if (!Integer.class.isAssignableFrom(explicitJavaType.getJavaTypeClass())) {
                        throw new MappingException("Explicit JavaTypeDescriptor [" + explicitJavaType + "] applied to enumerated value with EnumType#ORDINAL should handle `java.lang.Integer` as its relational type descriptor");
                    }
                    relationalJtd = explicitJavaType;
                } else {
                    relationalJtd = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Integer.class));
                }
                JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(-6);
                OrdinalEnumValueConverter<E> valueConverter = new OrdinalEnumValueConverter<E>(enumJavaDescriptor, jdbcType, relationalJtd);
                org.hibernate.type.EnumType legacyEnumType = new org.hibernate.type.EnumType(enumJavaDescriptor.getJavaTypeClass(), valueConverter, typeConfiguration);
                CustomType legacyEnumTypeWrapper = new CustomType(legacyEnumType, typeConfiguration);
                BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(relationalJtd, jdbcType);
                return new InferredBasicValueResolution<E>(jdbcMapping, enumJavaDescriptor, relationalJtd, jdbcType, valueConverter, legacyEnumTypeWrapper, ImmutableMutabilityPlan.INSTANCE);
            }
        }
        throw new MappingException("Unknown enumeration-style (JPA EnumType) : " + enumStyle);
    }

    public static InferredBasicValueResolution fromTemporal(TemporalJavaTypeDescriptor reflectedJtd, BasicJavaType explicitJavaType, JdbcType explicitJdbcType, Type resolvedJavaType, JdbcTypeDescriptorIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        TemporalType requestedTemporalPrecision = stdIndicators.getTemporalPrecision();
        if (explicitJavaType != null) {
            if (!TemporalJavaTypeDescriptor.class.isInstance(explicitJavaType)) {
                throw new MappingException("Explicit JavaTypeDescriptor [" + explicitJavaType + "] defined for temporal value must implement TemporalJavaTypeDescriptor");
            }
            TemporalJavaTypeDescriptor explicitTemporalJtd = (TemporalJavaTypeDescriptor)explicitJavaType;
            if (requestedTemporalPrecision != null && explicitTemporalJtd.getPrecision() != requestedTemporalPrecision) {
                throw new MappingException("Temporal precision (`jakarta.persistence.TemporalType`) mismatch... requested precision = " + requestedTemporalPrecision + "; explicit JavaTypeDescriptor (`" + explicitTemporalJtd + "`) precision = " + explicitTemporalJtd.getPrecision());
            }
            JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : explicitTemporalJtd.getRecommendedJdbcType(stdIndicators);
            BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitTemporalJtd, jdbcType);
            return new InferredBasicValueResolution(jdbcMapping, explicitTemporalJtd, explicitTemporalJtd, jdbcType, null, jdbcMapping, explicitJavaType.getMutabilityPlan());
        }
        if (explicitJdbcType != null) {
            TemporalJavaTypeDescriptor jtd = requestedTemporalPrecision != null ? reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration) : reflectedJtd;
            BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(jtd, explicitJdbcType);
            return new InferredBasicValueResolution(jdbcMapping, jtd, jtd, explicitJdbcType, null, jdbcMapping, jtd.getMutabilityPlan());
        }
        BasicType basicType = requestedTemporalPrecision != null && requestedTemporalPrecision != reflectedJtd.getPrecision() ? typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration), TemporalJavaTypeDescriptor.resolveJdbcTypeCode(requestedTemporalPrecision)) : typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, reflectedJtd.getRecommendedJdbcType(stdIndicators));
        return new InferredBasicValueResolution(basicType, basicType.getJavaTypeDescriptor(), basicType.getJavaTypeDescriptor(), basicType.getJdbcTypeDescriptor(), null, basicType, reflectedJtd.getMutabilityPlan());
    }
}

