/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class VersionResolution<E>
implements BasicValue.Resolution<E> {
    private final JavaType jtd;
    private final JdbcType jdbcType;
    private final JdbcMapping jdbcMapping;
    private final BasicType legacyType;

    public static <E> VersionResolution<E> from(Function<TypeConfiguration, Type> implicitJavaTypeAccess, Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, final TimeZoneStorageType timeZoneStorageType, final TypeConfiguration typeConfiguration, final MetadataBuildingContext context) {
        Type implicitJavaType = implicitJavaTypeAccess.apply(typeConfiguration);
        JavaType registered = typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor(implicitJavaType);
        BasicJavaType jtd = (BasicJavaType)registered;
        JdbcType recommendedJdbcType = jtd.getRecommendedJdbcType(new JdbcTypeDescriptorIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public TemporalType getTemporalPrecision() {
                return TemporalType.TIMESTAMP;
            }

            @Override
            public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
                if (timeZoneStorageType != null) {
                    switch (timeZoneStorageType) {
                        case COLUMN: {
                            return TimeZoneStorageStrategy.COLUMN;
                        }
                        case NATIVE: {
                            return TimeZoneStorageStrategy.NATIVE;
                        }
                        case NORMALIZE: {
                            return TimeZoneStorageStrategy.NORMALIZE;
                        }
                    }
                }
                return context.getBuildingOptions().getDefaultTimeZoneStorage();
            }
        });
        BasicType basicType = typeConfiguration.getBasicTypeRegistry().resolve(jtd, recommendedJdbcType);
        BasicType legacyType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(jtd.getJavaType());
        assert (legacyType.getJdbcTypeDescriptor().equals(recommendedJdbcType));
        return new VersionResolution<E>(jtd, recommendedJdbcType, basicType, legacyType);
    }

    public VersionResolution(JavaType javaTypeDescriptor, JdbcType jdbcType, JdbcMapping jdbcMapping, BasicType legacyType) {
        this.jtd = javaTypeDescriptor;
        this.jdbcType = jdbcType;
        this.jdbcMapping = jdbcMapping;
        this.legacyType = legacyType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public BasicType getLegacyResolvedBasicType() {
        return this.legacyType;
    }

    @Override
    public JavaType<E> getDomainJavaDescriptor() {
        return this.jtd;
    }

    @Override
    public JavaType<?> getRelationalJavaDescriptor() {
        return this.jtd;
    }

    @Override
    public JdbcType getJdbcTypeDescriptor() {
        return this.jdbcType;
    }

    @Override
    public BasicValueConverter<E, E> getValueConverter() {
        return null;
    }

    @Override
    public MutabilityPlan<E> getMutabilityPlan() {
        return ImmutableMutabilityPlan.instance();
    }
}

