/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.spi;

import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.process.internal.ManagedResourcesImpl;
import org.hibernate.boot.model.process.internal.ScanningCoordinator;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.model.process.spi.NoOpMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.annotations.AnnotationMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.hbm.EntityHierarchyBuilder;
import org.hibernate.boot.model.source.internal.hbm.EntityHierarchySourceImpl;
import org.hibernate.boot.model.source.internal.hbm.HbmMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.model.source.internal.hbm.ModelBinder;
import org.hibernate.boot.model.source.spi.MetadataSourceProcessor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.AdditionalJaxbMappingProducer;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.MetadataSourceType;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.internal.NamedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class MetadataBuildingProcess {
    private static final Logger log = Logger.getLogger(MetadataBuildingProcess.class);

    public static MetadataImplementor build(MetadataSources sources, BootstrapContext bootstrapContext, MetadataBuildingOptions options) {
        return MetadataBuildingProcess.complete(MetadataBuildingProcess.prepare(sources, bootstrapContext), bootstrapContext, options);
    }

    public static ManagedResources prepare(MetadataSources sources, BootstrapContext bootstrapContext) {
        ManagedResourcesImpl managedResources = ManagedResourcesImpl.baseline(sources, bootstrapContext);
        ConfigurationService configService = bootstrapContext.getServiceRegistry().getService(ConfigurationService.class);
        boolean xmlMappingEnabled = configService.getSetting("hibernate.xml_mapping_enabled", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        ScanningCoordinator.INSTANCE.coordinateScan(managedResources, bootstrapContext, xmlMappingEnabled ? sources.getXmlMappingBinderAccess() : null);
        return managedResources;
    }

    public static MetadataImplementor complete(final ManagedResources managedResources, BootstrapContext bootstrapContext, final MetadataBuildingOptions options) {
        Collection<AdditionalJaxbMappingProducer> producers;
        InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl(bootstrapContext, options);
        MetadataBuildingProcess.handleTypes(bootstrapContext, options);
        ClassLoaderService classLoaderService = options.getServiceRegistry().getService(ClassLoaderService.class);
        final MetadataBuildingContextRootImpl rootMetadataBuildingContext = new MetadataBuildingContextRootImpl("orm", bootstrapContext, options, metadataCollector);
        managedResources.getAttributeConverterDescriptors().forEach(metadataCollector::addAttributeConverter);
        bootstrapContext.getTypeConfiguration().scope(rootMetadataBuildingContext);
        final IndexView jandexView = bootstrapContext.getJandexView();
        MetadataSourceProcessor processor = new MetadataSourceProcessor(){
            private final MetadataSourceProcessor hbmProcessor;
            private final AnnotationMetadataSourceProcessorImpl annotationProcessor;
            {
                this.hbmProcessor = options.isXmlMappingEnabled() ? new HbmMetadataSourceProcessorImpl(managedResources, (MetadataBuildingContext)rootMetadataBuildingContext) : new NoOpMetadataSourceProcessorImpl();
                this.annotationProcessor = new AnnotationMetadataSourceProcessorImpl(managedResources, rootMetadataBuildingContext, jandexView);
            }

            @Override
            public void prepare() {
                this.hbmProcessor.prepare();
                this.annotationProcessor.prepare();
            }

            @Override
            public void processTypeDefinitions() {
                this.hbmProcessor.processTypeDefinitions();
                this.annotationProcessor.processTypeDefinitions();
            }

            @Override
            public void processQueryRenames() {
                this.hbmProcessor.processQueryRenames();
                this.annotationProcessor.processQueryRenames();
            }

            @Override
            public void processNamedQueries() {
                this.hbmProcessor.processNamedQueries();
                this.annotationProcessor.processNamedQueries();
            }

            @Override
            public void processAuxiliaryDatabaseObjectDefinitions() {
                this.hbmProcessor.processAuxiliaryDatabaseObjectDefinitions();
                this.annotationProcessor.processAuxiliaryDatabaseObjectDefinitions();
            }

            @Override
            public void processIdentifierGenerators() {
                this.hbmProcessor.processIdentifierGenerators();
                this.annotationProcessor.processIdentifierGenerators();
            }

            @Override
            public void processFilterDefinitions() {
                this.hbmProcessor.processFilterDefinitions();
                this.annotationProcessor.processFilterDefinitions();
            }

            @Override
            public void processFetchProfiles() {
                this.hbmProcessor.processFetchProfiles();
                this.annotationProcessor.processFetchProfiles();
            }

            @Override
            public void prepareForEntityHierarchyProcessing() {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.prepareForEntityHierarchyProcessing();
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.prepareForEntityHierarchyProcessing();
                }
            }

            @Override
            public void processEntityHierarchies(Set<String> processedEntityNames) {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.processEntityHierarchies(processedEntityNames);
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.processEntityHierarchies(processedEntityNames);
                }
            }

            @Override
            public void postProcessEntityHierarchies() {
                for (MetadataSourceType metadataSourceType : options.getSourceProcessOrdering()) {
                    if (metadataSourceType == MetadataSourceType.HBM) {
                        this.hbmProcessor.postProcessEntityHierarchies();
                    }
                    if (metadataSourceType != MetadataSourceType.CLASS) continue;
                    this.annotationProcessor.postProcessEntityHierarchies();
                }
            }

            @Override
            public void processResultSetMappings() {
                this.hbmProcessor.processResultSetMappings();
                this.annotationProcessor.processResultSetMappings();
            }

            @Override
            public void finishUp() {
                this.hbmProcessor.finishUp();
                this.annotationProcessor.finishUp();
            }
        };
        processor.prepare();
        processor.processTypeDefinitions();
        processor.processQueryRenames();
        processor.processAuxiliaryDatabaseObjectDefinitions();
        processor.processIdentifierGenerators();
        processor.processFilterDefinitions();
        processor.processFetchProfiles();
        HashSet<String> processedEntityNames = new HashSet<String>();
        processor.prepareForEntityHierarchyProcessing();
        processor.processEntityHierarchies(processedEntityNames);
        processor.postProcessEntityHierarchies();
        processor.processResultSetMappings();
        processor.processNamedQueries();
        processor.finishUp();
        for (MetadataContributor contributor : classLoaderService.loadJavaServices(MetadataContributor.class)) {
            log.tracef("Calling MetadataContributor : %s", (Object)contributor);
            contributor.contribute(metadataCollector, jandexView);
        }
        metadataCollector.processSecondPasses(rootMetadataBuildingContext);
        if (options.isXmlMappingEnabled() && (producers = classLoaderService.loadJavaServices(AdditionalJaxbMappingProducer.class)) != null) {
            EntityHierarchyBuilder hierarchyBuilder = new EntityHierarchyBuilder();
            MappingBinder mappingBinder = new MappingBinder(classLoaderService, false);
            for (AdditionalJaxbMappingProducer producer : producers) {
                log.tracef("Calling AdditionalJaxbMappingProducer : %s", (Object)producer);
                Collection<MappingDocument> additionalMappings = producer.produceAdditionalMappings(metadataCollector, jandexView, mappingBinder, rootMetadataBuildingContext);
                for (MappingDocument mappingDocument : additionalMappings) {
                    hierarchyBuilder.indexMappingDocument(mappingDocument);
                }
            }
            ModelBinder binder = ModelBinder.prepare(rootMetadataBuildingContext);
            for (EntityHierarchySourceImpl entityHierarchySource : hierarchyBuilder.buildHierarchies()) {
                binder.bindEntityHierarchy(entityHierarchySource);
            }
        }
        MetadataBuildingProcess.applyExtraQueryImports(managedResources, metadataCollector);
        return metadataCollector.buildMetadataInstance(rootMetadataBuildingContext);
    }

    private static void applyExtraQueryImports(ManagedResources managedResources, InFlightMetadataCollectorImpl metadataCollector) {
        Map<String, Class<?>> extraQueryImports = managedResources.getExtraQueryImports();
        if (extraQueryImports == null || extraQueryImports.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Class<?>> entry : extraQueryImports.entrySet()) {
            metadataCollector.addImport(entry.getKey(), entry.getValue().getName());
        }
    }

    private static void handleTypes(final BootstrapContext bootstrapContext, MetadataBuildingOptions options) {
        ClassLoaderService classLoaderService = options.getServiceRegistry().getService(ClassLoaderService.class);
        TypeContributions typeContributions = new TypeContributions(){

            @Override
            public void contributeType(BasicType type) {
                this.getBasicTypeRegistry().register(type);
                this.conditionallyRegisterJtd(type.getJavaTypeDescriptor());
            }

            private void conditionallyRegisterJtd(JavaType jtd) {
                JavaTypeRegistry jtdRegistry = this.getTypeConfiguration().getJavaTypeDescriptorRegistry();
                jtdRegistry.resolveDescriptor(jtd.getJavaTypeClass(), () -> jtd);
            }

            @Override
            public void contributeType(BasicType type, String ... keys) {
                this.getBasicTypeRegistry().register(type, keys);
                this.conditionallyRegisterJtd(type.getJavaTypeDescriptor());
            }

            @Override
            public void contributeType(UserType type, String[] keys) {
                this.contributeType(new CustomType(type, keys, this.getTypeConfiguration()));
            }

            @Override
            public void contributeJavaTypeDescriptor(JavaType descriptor) {
                bootstrapContext.getTypeConfiguration().getJavaTypeDescriptorRegistry().addDescriptor(descriptor);
            }

            @Override
            public void contributeJdbcTypeDescriptor(JdbcType descriptor) {
                bootstrapContext.getTypeConfiguration().getJdbcTypeDescriptorRegistry().addDescriptor(descriptor);
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return bootstrapContext.getTypeConfiguration();
            }

            final BasicTypeRegistry getBasicTypeRegistry() {
                return this.getTypeConfiguration().getBasicTypeRegistry();
            }
        };
        Dialect dialect = options.getServiceRegistry().getService(JdbcServices.class).getDialect();
        dialect.contributeTypes(typeContributions, options.getServiceRegistry());
        for (TypeContributor contributor : classLoaderService.loadJavaServices(TypeContributor.class)) {
            contributor.contribute(typeContributions, options.getServiceRegistry());
        }
        JdbcTypeRegistry jdbcTypeRegistry = bootstrapContext.getTypeConfiguration().getJdbcTypeDescriptorRegistry();
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3000, -2);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3001, -3);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3002, -3);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3100, 2);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3200, -3);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3201, -3);
        bootstrapContext.getTypeConfiguration().addBasicTypeRegistrationContributions(options.getBasicTypeRegistrations());
        if (options.getDefaultTimeZoneStorage() == TimeZoneStorageStrategy.NORMALIZE) {
            JavaTypeRegistry javaTypeRegistry = bootstrapContext.getTypeConfiguration().getJavaTypeDescriptorRegistry();
            JdbcType timestampDescriptor = jdbcTypeRegistry.getDescriptor(93);
            BasicTypeRegistry basicTypeRegistry = bootstrapContext.getTypeConfiguration().getBasicTypeRegistry();
            NamedBasicTypeImpl offsetDateTimeType = new NamedBasicTypeImpl(javaTypeRegistry.getDescriptor((Type)((Object)OffsetDateTime.class)), timestampDescriptor, "OffsetDateTime");
            NamedBasicTypeImpl zonedDateTimeType = new NamedBasicTypeImpl(javaTypeRegistry.getDescriptor((Type)((Object)ZonedDateTime.class)), timestampDescriptor, "ZonedDateTime");
            basicTypeRegistry.register(offsetDateTimeType, "org.hibernate.type.OffsetDateTimeType", OffsetDateTime.class.getSimpleName(), OffsetDateTime.class.getName());
            basicTypeRegistry.register(zonedDateTimeType, "org.hibernate.type.ZonedDateTimeType", ZonedDateTime.class.getSimpleName(), ZonedDateTime.class.getName());
        }
    }

    private static void addFallbackIfNecessary(JdbcTypeRegistry jdbcTypeRegistry, int typeCode, int fallbackTypeCode) {
        if (!jdbcTypeRegistry.hasRegisteredDescriptor(typeCode)) {
            jdbcTypeRegistry.addDescriptor(typeCode, jdbcTypeRegistry.getDescriptor(fallbackTypeCode));
        }
    }
}

