/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.MapKeyTemporal;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.AnyKeyJavaType;
import org.hibernate.annotations.AnyKeyJdbcType;
import org.hibernate.annotations.AnyKeyJdbcTypeCode;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionIdCustomType;
import org.hibernate.annotations.CollectionIdJavaType;
import org.hibernate.annotations.CollectionIdJdbcType;
import org.hibernate.annotations.CollectionIdJdbcTypeCode;
import org.hibernate.annotations.CollectionIdMutability;
import org.hibernate.annotations.CustomType;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.ListIndexJavaType;
import org.hibernate.annotations.ListIndexJdbcType;
import org.hibernate.annotations.ListIndexJdbcTypeCode;
import org.hibernate.annotations.MapKeyCustomType;
import org.hibernate.annotations.MapKeyJavaType;
import org.hibernate.annotations.MapKeyJdbcType;
import org.hibernate.annotations.MapKeyJdbcTypeCode;
import org.hibernate.annotations.MapKeyMutability;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.annotations.TimeZoneType;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.SetBasicValueTypeSecondPass;
import org.hibernate.cfg.annotations.HCANNHelper;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Table;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.EnumType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;

public class BasicValueBinder<T>
implements JdbcTypeDescriptorIndicators {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BasicValueBinder.class.getName());
    private final Kind kind;
    private final MetadataBuildingContext buildingContext;
    private final ClassLoaderService classLoaderService;
    private final StrategySelector strategySelector;
    private String explicitBasicTypeName;
    private Class<? extends UserType<?>> explicitCustomType;
    private Map explicitLocalTypeParams;
    private Function<TypeConfiguration, JdbcType> explicitJdbcTypeAccess;
    private Function<TypeConfiguration, BasicJavaType> explicitJavaTypeAccess;
    private Function<TypeConfiguration, MutabilityPlan> explicitMutabilityAccess;
    private Function<TypeConfiguration, Type> implicitJavaTypeAccess;
    private XProperty xproperty;
    private AccessType accessType;
    private ConverterDescriptor converterDescriptor;
    private boolean isVersion;
    private boolean isNationalized;
    private boolean isLob;
    private jakarta.persistence.EnumType enumType;
    private TemporalType temporalPrecision;
    private TimeZoneStorageType timeZoneStorageType;
    private Table table;
    private Ejb3Column[] columns;
    private BasicValue basicValue;
    private String timeStampVersionType;
    private String persistentClassName;
    private String propertyName;
    private String returnedClassName;
    private String referencedEntityName;

    public BasicValueBinder(Kind kind, MetadataBuildingContext buildingContext) {
        assert (kind != null);
        assert (buildingContext != null);
        this.kind = kind;
        this.buildingContext = buildingContext;
        this.classLoaderService = buildingContext.getBootstrapContext().getServiceRegistry().getService(ClassLoaderService.class);
        this.strategySelector = buildingContext.getBootstrapContext().getServiceRegistry().getService(StrategySelector.class);
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.buildingContext.getBootstrapContext().getTypeConfiguration();
    }

    @Override
    public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        if (this.timeZoneStorageType != null) {
            switch (this.timeZoneStorageType) {
                case COLUMN: {
                    return TimeZoneStorageStrategy.COLUMN;
                }
                case NATIVE: {
                    return TimeZoneStorageStrategy.NATIVE;
                }
                case NORMALIZE: {
                    return TimeZoneStorageStrategy.NORMALIZE;
                }
            }
        }
        return this.buildingContext.getBuildingOptions().getDefaultTimeZoneStorage();
    }

    @Override
    public jakarta.persistence.EnumType getEnumeratedType() {
        return this.enumType;
    }

    @Override
    public boolean isLob() {
        return this.isLob;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.buildingContext.getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public boolean isNationalized() {
        return this.isNationalized;
    }

    public void setVersion(boolean isVersion) {
        this.isVersion = isVersion;
        if (isVersion && this.basicValue != null) {
            this.basicValue.makeVersion();
        }
    }

    public void setTimestampVersionType(String versionType) {
        this.timeStampVersionType = versionType;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Ejb3Column[] columns) {
        this.columns = columns;
    }

    public void setPersistentClassName(String persistentClassName) {
        this.persistentClassName = persistentClassName;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setType(XProperty modelXProperty, XClass modelPropertyTypeXClass, String declaringClassName, ConverterDescriptor converterDescriptor) {
        this.xproperty = modelXProperty;
        boolean isArray = modelXProperty.isArray();
        if (modelPropertyTypeXClass == null && !isArray) {
            return;
        }
        if (this.columns == null) {
            throw new AssertionFailure("`BasicValueBinder#setColumns` should be called before `BasicValueBinder#setType`");
        }
        if (this.columns.length != 1) {
            throw new AssertionFailure("Expecting just one column, but found `" + Arrays.toString(this.columns) + "`");
        }
        XClass modelTypeXClass = isArray ? modelXProperty.getElementClass() : modelPropertyTypeXClass;
        Class modelJavaType = BasicValueBinder.resolveJavaType(modelTypeXClass, this.buildingContext);
        if (modelJavaType == null) {
            throw new IllegalStateException("BasicType requires Java type");
        }
        Class modelPropertyJavaType = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(modelXProperty.getType());
        boolean isMap = Map.class.isAssignableFrom(modelPropertyJavaType);
        if (this.kind != Kind.LIST_INDEX && this.kind != Kind.MAP_KEY) {
            this.isLob = modelXProperty.isAnnotationPresent(Lob.class);
        }
        if (this.getDialect().getNationalizationSupport() == NationalizationSupport.EXPLICIT) {
            this.isNationalized = modelXProperty.isAnnotationPresent(Nationalized.class) || this.buildingContext.getBuildingOptions().useNationalizedCharacterData();
        }
        this.applyJpaConverter(modelXProperty, converterDescriptor);
        Class<? extends UserType> userTypeImpl = this.kind.mappingAccess.customType(modelXProperty);
        if (userTypeImpl != null) {
            this.applyExplicitType(userTypeImpl, this.kind.mappingAccess.customTypeParameters(modelXProperty));
            return;
        }
        switch (this.kind) {
            case ATTRIBUTE: {
                this.prepareBasicAttribute(declaringClassName, modelXProperty, modelPropertyTypeXClass);
                break;
            }
            case ANY_DISCRIMINATOR: {
                this.prepareAnyDiscriminator(modelXProperty);
                break;
            }
            case ANY_KEY: {
                this.prepareAnyKey(modelXProperty);
                break;
            }
            case COLLECTION_ID: {
                this.prepareCollectionId(modelXProperty);
                break;
            }
            case LIST_INDEX: {
                this.prepareListIndex(modelXProperty);
                break;
            }
            case MAP_KEY: {
                this.prepareMapKey(modelXProperty, modelPropertyTypeXClass);
                break;
            }
            case COLLECTION_ELEMENT: {
                this.prepareCollectionElement(modelXProperty, modelPropertyTypeXClass);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected binder type : " + this.kind);
            }
        }
    }

    private void applyExplicitType(Class<? extends UserType> impl, Parameter[] params) {
        this.explicitCustomType = impl;
        this.explicitLocalTypeParams = this.extractTypeParams(params);
    }

    private Map extractTypeParams(Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return Collections.emptyMap();
        }
        if (parameters.length == 1) {
            return Collections.singletonMap(parameters[0].name(), parameters[0].value());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter parameter : parameters) {
            map.put(parameter.name(), parameter.value());
        }
        return map;
    }

    private void prepareCollectionId(XProperty modelXProperty) {
        CollectionId collectionIdAnn = (CollectionId)modelXProperty.getAnnotation(CollectionId.class);
        if (collectionIdAnn == null) {
            throw new MappingException("idbag mapping missing @CollectionId");
        }
        ManagedBeanRegistry beanRegistry = this.buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        this.explicitBasicTypeName = null;
        this.implicitJavaTypeAccess = typeConfiguration -> null;
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<BasicJavaType<?>> javaType;
            CollectionIdJavaType javaTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, CollectionIdJavaType.class);
            if (javaTypeAnn != null && (javaType = BasicValueBinder.normalizeJavaType(javaTypeAnn.value())) != null) {
                ManagedBean<BasicJavaType<?>> bean = beanRegistry.getBean(javaType);
                return bean.getBeanInstance();
            }
            return null;
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            Class<JdbcType> jdbcType;
            CollectionIdJdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, CollectionIdJdbcType.class);
            if (jdbcTypeAnn != null && (jdbcType = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                ManagedBean<JdbcType> managedBean = beanRegistry.getBean(jdbcType);
                return managedBean.getBeanInstance();
            }
            CollectionIdJdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, CollectionIdJdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && jdbcTypeCodeAnn.value() != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(jdbcTypeCodeAnn.value());
            }
            return null;
        };
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<? extends UserType> customTypeImpl;
            Class attributeType;
            Class<MutabilityPlan<?>> mutability;
            CollectionIdMutability mutabilityAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, CollectionIdMutability.class);
            if (mutabilityAnn != null && (mutability = this.normalizeMutability(mutabilityAnn.value())) != null) {
                ManagedBean<MutabilityPlan<?>> jtdBean = beanRegistry.getBean(mutability);
                return jtdBean.getBeanInstance();
            }
            if (this.implicitJavaTypeAccess != null && (attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration))) != null && attributeType.isAnnotationPresent(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    ManagedBean<MutabilityPlan<?>> jtdBean = beanRegistry.getBean(converterMutabilityAnn.value());
                    return jtdBean.getBeanInstance();
                }
                if (this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.ATTRIBUTE.mappingAccess.customType(modelXProperty)).isAnnotationPresent(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            return null;
        };
        String generator = collectionIdAnn.generator();
    }

    private void prepareMapKey(XProperty mapAttribute, XClass modelPropertyTypeXClass) {
        MapKeyTemporal mapKeyTemporalAnn;
        XClass mapKeyClass = modelPropertyTypeXClass == null ? mapAttribute.getMapKey() : modelPropertyTypeXClass;
        Class implicitJavaType = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(mapKeyClass);
        this.implicitJavaTypeAccess = typeConfiguration -> implicitJavaType;
        MapKeyEnumerated mapKeyEnumeratedAnn = (MapKeyEnumerated)mapAttribute.getAnnotation(MapKeyEnumerated.class);
        if (mapKeyEnumeratedAnn != null) {
            this.enumType = mapKeyEnumeratedAnn.value();
        }
        if ((mapKeyTemporalAnn = (MapKeyTemporal)mapAttribute.getAnnotation(MapKeyTemporal.class)) != null) {
            this.temporalPrecision = mapKeyTemporalAnn.value();
        }
        ManagedBeanRegistry managedBeanRegistry = this.buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int jdbcTypeCode;
            Class<JdbcType> jdbcTypeImpl;
            MapKeyJdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)mapAttribute, MapKeyJdbcType.class);
            if (jdbcTypeAnn != null && (jdbcTypeImpl = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                ManagedBean<JdbcType> jdbcTypeBean = managedBeanRegistry.getBean(jdbcTypeImpl);
                return jdbcTypeBean.getBeanInstance();
            }
            MapKeyJdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)mapAttribute, MapKeyJdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && (jdbcTypeCode = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(jdbcTypeCode);
            }
            return null;
        };
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<BasicJavaType<?>> jdbcTypeImpl;
            MapKeyJavaType javaTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)mapAttribute, MapKeyJavaType.class);
            if (javaTypeAnn != null && (jdbcTypeImpl = BasicValueBinder.normalizeJavaType(javaTypeAnn.value())) != null) {
                ManagedBean<BasicJavaType<?>> jdbcTypeBean = managedBeanRegistry.getBean(jdbcTypeImpl);
                return jdbcTypeBean.getBeanInstance();
            }
            MapKeyClass mapKeyClassAnn = (MapKeyClass)mapAttribute.getAnnotation(MapKeyClass.class);
            if (mapKeyClassAnn != null) {
                return (BasicJavaType)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(mapKeyClassAnn.value());
            }
            return null;
        };
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<? extends UserType> customTypeImpl;
            Class attributeType;
            Class<MutabilityPlan<?>> mutability;
            MapKeyMutability mutabilityAnn = HCANNHelper.findAnnotation((XAnnotatedElement)mapAttribute, MapKeyMutability.class);
            if (mutabilityAnn != null && (mutability = this.normalizeMutability(mutabilityAnn.value())) != null) {
                ManagedBean<MutabilityPlan<?>> jtdBean = managedBeanRegistry.getBean(mutability);
                return jtdBean.getBeanInstance();
            }
            if (this.implicitJavaTypeAccess != null && (attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration))) != null && attributeType.isAnnotationPresent(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    ManagedBean<MutabilityPlan<?>> jtdBean = managedBeanRegistry.getBean(converterMutabilityAnn.value());
                    return jtdBean.getBeanInstance();
                }
                if (this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.MAP_KEY.mappingAccess.customType(mapAttribute)) != null && customTypeImpl.isAnnotationPresent(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            return null;
        };
    }

    private void prepareListIndex(XProperty listAttribute) {
        this.implicitJavaTypeAccess = typeConfiguration -> Integer.class;
        ManagedBeanRegistry beanRegistry = this.buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<BasicJavaType<?>> javaType;
            ListIndexJavaType javaTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)listAttribute, ListIndexJavaType.class);
            if (javaTypeAnn != null && (javaType = BasicValueBinder.normalizeJavaType(javaTypeAnn.value())) != null) {
                ManagedBean<BasicJavaType<?>> bean = beanRegistry.getBean(javaType);
                return bean.getBeanInstance();
            }
            return null;
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            Class<JdbcType> jdbcType;
            ListIndexJdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)listAttribute, ListIndexJdbcType.class);
            if (jdbcTypeAnn != null && (jdbcType = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                ManagedBean<JdbcType> bean = beanRegistry.getBean(jdbcType);
                return bean.getBeanInstance();
            }
            ListIndexJdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)listAttribute, ListIndexJdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null) {
                return typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(jdbcTypeCodeAnn.value());
            }
            return null;
        };
    }

    private void prepareCollectionElement(XProperty attributeXProperty, XClass elementTypeXClass) {
        TimeZoneStorage timeZoneStorageAnn;
        Class javaType = elementTypeXClass == null && attributeXProperty.isArray() ? this.buildingContext.getBootstrapContext().getReflectionManager().toClass(attributeXProperty.getElementClass()) : this.buildingContext.getBootstrapContext().getReflectionManager().toClass(elementTypeXClass);
        this.implicitJavaTypeAccess = typeConfiguration -> javaType;
        Temporal temporalAnn = (Temporal)attributeXProperty.getAnnotation(Temporal.class);
        if (temporalAnn != null) {
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No jakarta.persistence.TemporalType defined for @jakarta.persistence.Temporal associated with attribute " + attributeXProperty.getDeclaringClass().getName() + "." + attributeXProperty.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if (javaType.isEnum()) {
            Enumerated enumeratedAnn = (Enumerated)attributeXProperty.getAnnotation(Enumerated.class);
            if (enumeratedAnn != null) {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("jakarta.persistence.EnumType was null on @jakarta.persistence.Enumerated  associated with attribute " + attributeXProperty.getDeclaringClass().getName() + "." + attributeXProperty.getName());
                }
            }
        } else {
            this.enumType = null;
        }
        if ((timeZoneStorageAnn = (TimeZoneStorage)attributeXProperty.getAnnotation(TimeZoneStorage.class)) != null) {
            Column column;
            this.timeZoneStorageType = timeZoneStorageAnn.value();
            TimeZoneColumn timeZoneColumnAnn = (TimeZoneColumn)attributeXProperty.getAnnotation(TimeZoneColumn.class);
            if (timeZoneColumnAnn != null) {
                column = timeZoneColumnAnn.column();
                TimeZoneType type = timeZoneColumnAnn.type();
            } else {
                switch (this.timeZoneStorageType) {
                    case AUTO: {
                        Dialect dialect = this.buildingContext.getBootstrapContext().getServiceRegistry().getService(JdbcServices.class).getDialect();
                        if (dialect.getTimeZoneSupport() == TimeZoneSupport.NATIVE) {
                            column = null;
                            Object type = null;
                            break;
                        }
                    }
                    case COLUMN: {
                        final String timeZoneColumnName = this.columns[0].getName() + "_tz";
                        column = new Column(){

                            public String name() {
                                return timeZoneColumnName;
                            }

                            public boolean unique() {
                                return false;
                            }

                            public boolean nullable() {
                                return BasicValueBinder.this.columns[0].isNullable();
                            }

                            public boolean insertable() {
                                return BasicValueBinder.this.columns[0].isInsertable();
                            }

                            public boolean updatable() {
                                return BasicValueBinder.this.columns[0].isUpdatable();
                            }

                            public String columnDefinition() {
                                return "";
                            }

                            public String table() {
                                return BasicValueBinder.this.columns[0].getExplicitTableName();
                            }

                            public int length() {
                                return 255;
                            }

                            public int precision() {
                                return 0;
                            }

                            public int scale() {
                                return 0;
                            }

                            public Class<? extends Annotation> annotationType() {
                                return Column.class;
                            }
                        };
                        TimeZoneType type = TimeZoneType.OFFSET;
                        break;
                    }
                    default: {
                        column = null;
                        Object type = null;
                    }
                }
            }
            if (column != null) {
                throw new NotYetImplementedFor6Exception("TimeZoneColumn support is not yet implemented!");
            }
            if (timeZoneColumnAnn != null) {
                throw new IllegalStateException("@TimeZoneColumn can not be used in conjunction with @TimeZoneStorage( " + this.timeZoneStorageType + " ) with attribute " + attributeXProperty.getDeclaringClass().getName() + "." + attributeXProperty.getName());
            }
        } else {
            this.timeZoneStorageType = null;
        }
        this.normalSupplementalDetails(attributeXProperty, this.buildingContext);
        ElementCollection elementCollectionAnn = (ElementCollection)attributeXProperty.getAnnotation(ElementCollection.class);
        if (elementCollectionAnn != null && elementCollectionAnn.targetClass() != null && elementCollectionAnn.targetClass() != Void.TYPE) {
            Function<TypeConfiguration, BasicJavaType> original = this.explicitJavaTypeAccess;
            this.explicitJavaTypeAccess = typeConfiguration -> {
                BasicJavaType originalResult = (BasicJavaType)original.apply((TypeConfiguration)typeConfiguration);
                if (originalResult != null) {
                    return originalResult;
                }
                return (BasicJavaType)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(elementCollectionAnn.targetClass());
            };
        }
    }

    private void prepareBasicAttribute(String declaringClassName, XProperty attributeDescriptor, XClass attributeType) {
        Class javaType = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(attributeType);
        this.implicitJavaTypeAccess = typeConfiguration -> javaType;
        Temporal temporalAnn = (Temporal)attributeDescriptor.getAnnotation(Temporal.class);
        if (temporalAnn != null) {
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No jakarta.persistence.TemporalType defined for @jakarta.persistence.Temporal associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + "." + attributeDescriptor.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if (javaType.isEnum()) {
            Enumerated enumeratedAnn = (Enumerated)attributeDescriptor.getAnnotation(Enumerated.class);
            if (enumeratedAnn != null) {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("jakarta.persistence.EnumType was null on @jakarta.persistence.Enumerated  associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + "." + attributeDescriptor.getName());
                }
            }
        } else {
            if (attributeDescriptor.isAnnotationPresent(Enumerated.class)) {
                throw new AnnotationException(String.format("Attribute [%s.%s] was annotated as enumerated, but its java type is not an enum [%s]", declaringClassName, attributeDescriptor.getName(), attributeType.getName()));
            }
            this.enumType = null;
        }
        this.normalSupplementalDetails(attributeDescriptor, this.buildingContext);
    }

    private void prepareAnyDiscriminator(XProperty modelXProperty) {
        AnyDiscriminator anyDiscriminatorAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyDiscriminator.class);
        this.implicitJavaTypeAccess = typeConfiguration -> {
            if (anyDiscriminatorAnn != null) {
                switch (anyDiscriminatorAnn.value()) {
                    case CHAR: {
                        return Character.class;
                    }
                    case INTEGER: {
                        return Integer.class;
                    }
                }
                return String.class;
            }
            return String.class;
        };
        this.normalJdbcTypeDetails(modelXProperty, this.buildingContext);
        this.normalMutabilityDetails(modelXProperty, this.buildingContext);
        Function<TypeConfiguration, JdbcType> originalJdbcTypeResolution = this.explicitJdbcTypeAccess;
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            JdbcType originalResolution = (JdbcType)originalJdbcTypeResolution.apply((TypeConfiguration)typeConfiguration);
            if (originalResolution != null) {
                return originalResolution;
            }
            Class hintedJavaType = (Class)this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration);
            JavaType hintedDescriptor = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(hintedJavaType);
            return hintedDescriptor.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
        };
    }

    private void prepareAnyKey(XProperty modelXProperty) {
        this.implicitJavaTypeAccess = typeConfiguration -> null;
        ManagedBeanRegistry managedBeanRegistry = this.buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<BasicJavaType<?>> javaType;
            AnyKeyJavaType javaTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyKeyJavaType.class);
            if (javaTypeAnn != null && (javaType = BasicValueBinder.normalizeJavaType(javaTypeAnn.value())) != null) {
                ManagedBean<BasicJavaType<?>> jtdBean = managedBeanRegistry.getBean(javaType);
                return jtdBean.getBeanInstance();
            }
            AnyKeyJavaClass javaClassAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyKeyJavaClass.class);
            if (javaClassAnn != null) {
                return (BasicJavaType)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(javaClassAnn.value());
            }
            return null;
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            Class<JdbcType> jdbcType;
            AnyKeyJdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyKeyJdbcType.class);
            if (jdbcTypeAnn != null && (jdbcType = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                ManagedBean<JdbcType> jtdBean = managedBeanRegistry.getBean(jdbcType);
                return jtdBean.getBeanInstance();
            }
            AnyKeyJdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)modelXProperty, AnyKeyJdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && jdbcTypeCodeAnn.value() != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(jdbcTypeCodeAnn.value());
            }
            return null;
        };
    }

    private void normalJdbcTypeDetails(XProperty attributeXProperty, MetadataBuildingContext buildingContext) {
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int jdbcTypeCode;
            Class<JdbcType> jdbcType;
            ManagedBeanRegistry managedBeanRegistry = buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
            org.hibernate.annotations.JdbcType jdbcTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, org.hibernate.annotations.JdbcType.class);
            if (jdbcTypeAnn != null && (jdbcType = this.normalizeJdbcType(jdbcTypeAnn.value())) != null) {
                ManagedBean<JdbcType> jdbcTypeBean = managedBeanRegistry.getBean(jdbcType);
                return jdbcTypeBean.getBeanInstance();
            }
            JdbcTypeCode jdbcTypeCodeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, JdbcTypeCode.class);
            if (jdbcTypeCodeAnn != null && (jdbcTypeCode = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(jdbcTypeCode);
            }
            return null;
        };
    }

    private void normalMutabilityDetails(XProperty attributeXProperty, MetadataBuildingContext buildingContext) {
        ManagedBeanRegistry managedBeanRegistry = buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<? extends UserType> customTypeImpl;
            Class attributeType;
            Class<MutabilityPlan<?>> mutability;
            Mutability mutabilityAnn = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, Mutability.class);
            if (mutabilityAnn != null && (mutability = this.normalizeMutability(mutabilityAnn.value())) != null) {
                ManagedBean<MutabilityPlan<?>> jtdBean = managedBeanRegistry.getBean(mutability);
                return jtdBean.getBeanInstance();
            }
            Immutable immutableAnn = (Immutable)attributeXProperty.getAnnotation(Immutable.class);
            if (immutableAnn != null) {
                return ImmutableMutabilityPlan.instance();
            }
            if (this.implicitJavaTypeAccess != null && (attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration))) != null && attributeType.isAnnotationPresent(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    ManagedBean<MutabilityPlan<?>> jtdBean = managedBeanRegistry.getBean(converterMutabilityAnn.value());
                    return jtdBean.getBeanInstance();
                }
                if (this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.ATTRIBUTE.mappingAccess.customType(attributeXProperty)) != null && customTypeImpl.isAnnotationPresent(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            return null;
        };
    }

    private void normalSupplementalDetails(XProperty attributeXProperty, MetadataBuildingContext buildingContext) {
        Temporal temporalAnn;
        ManagedBeanRegistry managedBeanRegistry = buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<BasicJavaType<?>> javaType;
            org.hibernate.annotations.JavaType javaTypeAnn = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, org.hibernate.annotations.JavaType.class);
            if (javaTypeAnn != null && (javaType = BasicValueBinder.normalizeJavaType(javaTypeAnn.value())) != null) {
                ManagedBean<BasicJavaType<?>> jtdBean = managedBeanRegistry.getBean(javaType);
                return jtdBean.getBeanInstance();
            }
            Target targetAnn = HCANNHelper.findAnnotation((XAnnotatedElement)attributeXProperty, Target.class);
            if (targetAnn != null) {
                return (BasicJavaType)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(targetAnn.value());
            }
            return null;
        };
        this.normalJdbcTypeDetails(attributeXProperty, buildingContext);
        this.normalMutabilityDetails(attributeXProperty, buildingContext);
        Enumerated enumeratedAnn = (Enumerated)attributeXProperty.getAnnotation(Enumerated.class);
        if (enumeratedAnn != null) {
            this.enumType = enumeratedAnn.value();
        }
        if ((temporalAnn = (Temporal)attributeXProperty.getAnnotation(Temporal.class)) != null) {
            this.temporalPrecision = temporalAnn.value();
        }
    }

    private static Class<? extends UserType<?>> normalizeUserType(Class<? extends UserType<?>> userType) {
        if (userType == null) {
            return null;
        }
        return userType;
    }

    private Class<? extends JdbcType> normalizeJdbcType(Class<? extends JdbcType> jdbcType) {
        if (jdbcType == null) {
            return null;
        }
        return jdbcType;
    }

    private static Class<? extends BasicJavaType<?>> normalizeJavaType(Class<? extends BasicJavaType<?>> javaType) {
        if (javaType == null) {
            return null;
        }
        return javaType;
    }

    private Class<? extends MutabilityPlan<?>> normalizeMutability(Class<? extends MutabilityPlan<?>> mutability) {
        if (mutability == null) {
            return null;
        }
        return mutability;
    }

    private static Class resolveJavaType(XClass returnedClassOrElement, MetadataBuildingContext buildingContext) {
        return buildingContext.getBootstrapContext().getReflectionManager().toClass(returnedClassOrElement);
    }

    private Dialect getDialect() {
        return this.buildingContext.getBuildingOptions().getServiceRegistry().getService(JdbcServices.class).getJdbcEnvironment().getDialect();
    }

    private void applyJpaConverter(XProperty property, ConverterDescriptor attributeConverterDescriptor) {
        if (attributeConverterDescriptor == null) {
            return;
        }
        LOG.debugf("Applying JPA converter [%s:%s]", this.persistentClassName, property.getName());
        if (property.isAnnotationPresent(Id.class)) {
            LOG.debugf("Skipping AttributeConverter checks for Id attribute [%s]", property.getName());
            return;
        }
        if (property.isAnnotationPresent(Version.class)) {
            LOG.debugf("Skipping AttributeConverter checks for version attribute [%s]", property.getName());
            return;
        }
        if (this.kind == Kind.MAP_KEY) {
            if (property.isAnnotationPresent(MapKeyTemporal.class)) {
                LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyTemporal [%s]", property.getName());
                return;
            }
            if (property.isAnnotationPresent(MapKeyEnumerated.class)) {
                LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyEnumerated [%s]", property.getName());
                return;
            }
        } else {
            if (property.isAnnotationPresent(Temporal.class)) {
                LOG.debugf("Skipping AttributeConverter checks for Temporal attribute [%s]", property.getName());
                return;
            }
            if (property.isAnnotationPresent(Enumerated.class)) {
                LOG.debugf("Skipping AttributeConverter checks for Enumerated attribute [%s]", property.getName());
                return;
            }
        }
        if (this.isAssociation()) {
            LOG.debugf("Skipping AttributeConverter checks for association attribute [%s]", property.getName());
            return;
        }
        this.converterDescriptor = attributeConverterDescriptor;
    }

    private boolean isAssociation() {
        return this.referencedEntityName != null;
    }

    public void setExplicitType(String explicitType) {
        this.explicitBasicTypeName = explicitType;
    }

    private void validate() {
        Ejb3Column.checkPropertyConsistency(this.columns, this.propertyName);
    }

    public BasicValue make() {
        if (this.basicValue != null) {
            return this.basicValue;
        }
        this.validate();
        LOG.debugf("building BasicValue for %s", this.propertyName);
        if (this.table == null) {
            this.table = this.columns[0].getTable();
        }
        this.basicValue = new BasicValue(this.buildingContext, this.table);
        if (this.isNationalized) {
            this.basicValue.makeNationalized();
        }
        if (this.isLob) {
            this.basicValue.makeLob();
        }
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.timeZoneStorageType != null) {
            this.basicValue.setTimeZoneStorageType(this.timeZoneStorageType);
        }
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        this.linkWithValue();
        boolean isInSecondPass = this.buildingContext.getMetadataCollector().isInSecondPass();
        if (!isInSecondPass) {
            this.buildingContext.getMetadataCollector().addSecondPass(new SetBasicValueTypeSecondPass(this));
        } else {
            this.fillSimpleValue();
        }
        return this.basicValue;
    }

    public void linkWithValue() {
        if (this.columns[0].isNameDeferred() && !this.buildingContext.getMetadataCollector().isInSecondPass() && this.referencedEntityName != null) {
            this.buildingContext.getMetadataCollector().addSecondPass(new PkDrivenByDefaultMapsIdSecondPass(this.referencedEntityName, (Ejb3JoinColumn[])this.columns, this.basicValue));
        } else {
            for (Ejb3Column column : this.columns) {
                column.linkWithValue(this.basicValue);
            }
        }
    }

    public void fillSimpleValue() {
        LOG.debugf("Starting `BasicValueBinder#fillSimpleValue` for %s", this.propertyName);
        this.basicValue.setExplicitTypeName(this.explicitBasicTypeName);
        this.basicValue.setExplicitTypeParams(this.explicitLocalTypeParams);
        Class typeClass = null;
        if (this.explicitBasicTypeName != null) {
            TypeDefinition typeDefinition = this.buildingContext.getTypeDefinitionRegistry().resolve(this.explicitBasicTypeName);
            if (typeDefinition == null) {
                BasicType registeredType = this.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(this.explicitBasicTypeName);
                if (registeredType == null) {
                    typeClass = this.buildingContext.getBootstrapContext().getClassLoaderAccess().classForName(this.explicitBasicTypeName);
                }
            } else {
                typeClass = typeDefinition.getTypeImplementorClass();
            }
        } else if (this.enumType != null || this.isEnum()) {
            typeClass = EnumType.class;
        } else if (this.isLob || this.isSerializable()) {
            typeClass = SerializableToBlobType.class;
        }
        if (this.explicitCustomType != null && DynamicParameterizedType.class.isAssignableFrom(this.explicitCustomType) || typeClass != null && DynamicParameterizedType.class.isAssignableFrom(typeClass)) {
            Map<String, Object> parameters = this.createDynamicParameterizedTypeParameters();
            this.basicValue.setTypeParameters(parameters);
        }
        this.basicValue.setJpaAttributeConverterDescriptor(this.converterDescriptor);
        this.basicValue.setImplicitJavaTypeAccess(this.implicitJavaTypeAccess);
        this.basicValue.setExplicitJavaTypeAccess(this.explicitJavaTypeAccess);
        this.basicValue.setExplicitJdbcTypeAccess(this.explicitJdbcTypeAccess);
        this.basicValue.setExplicitMutabilityPlanAccess(this.explicitMutabilityAccess);
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.timeZoneStorageType != null) {
            this.basicValue.setTimeZoneStorageType(this.timeZoneStorageType);
        }
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        if (this.isLob) {
            this.basicValue.makeLob();
        }
        if (this.isNationalized) {
            this.basicValue.makeNationalized();
        }
        if (this.explicitCustomType != null) {
            this.basicValue.setExplicitCustomType(this.explicitCustomType);
        }
    }

    private Map<String, Object> createDynamicParameterizedTypeParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.returnedClassName == null) {
            throw new MappingException("Returned class name not specified for basic mapping: " + this.xproperty.getName());
        }
        parameters.put("org.hibernate.type.ParameterType.returnedClass", this.returnedClassName);
        parameters.put("org.hibernate.type.ParameterType.xproperty", this.xproperty);
        parameters.put("org.hibernate.type.ParameterType.propertyName", this.xproperty.getName());
        parameters.put("org.hibernate.type.ParameterType.dynamic", Boolean.toString(true));
        parameters.put("org.hibernate.type.ParameterType.primaryKey", Boolean.toString(this.kind == Kind.MAP_KEY));
        if (this.persistentClassName != null) {
            parameters.put("org.hibernate.type.ParameterType.entityClass", this.persistentClassName);
        }
        if (this.returnedClassName != null) {
            parameters.put("org.hibernate.type.ParameterType.returnedClass", this.returnedClassName);
        }
        if (this.accessType != null) {
            parameters.put("org.hibernate.type.ParameterType.accessType", this.accessType.getType());
        }
        if (this.explicitLocalTypeParams != null) {
            parameters.putAll(this.explicitLocalTypeParams);
        }
        return parameters;
    }

    private boolean isEnum() {
        Class clazz = null;
        if (this.implicitJavaTypeAccess != null) {
            Type type = this.implicitJavaTypeAccess.apply(this.getTypeConfiguration());
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                clazz = (Class)type;
            }
        }
        return clazz != null && clazz.isEnum();
    }

    private boolean isSerializable() {
        Class clazz = null;
        if (this.implicitJavaTypeAccess != null) {
            Type type = this.implicitJavaTypeAccess.apply(this.getTypeConfiguration());
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                clazz = (Class)type;
            }
        }
        return clazz != null && Serializable.class.isAssignableFrom(clazz);
    }

    private static class ListIndexMappingAccess
    implements BasicMappingAccess {
        public static final ListIndexMappingAccess INSTANCE = new ListIndexMappingAccess();

        private ListIndexMappingAccess() {
        }

        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            return null;
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            return null;
        }
    }

    private static class CollectionIdMappingAccess
    implements BasicMappingAccess {
        public static final CollectionIdMappingAccess INSTANCE = new CollectionIdMappingAccess();

        private CollectionIdMappingAccess() {
        }

        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            CollectionIdCustomType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, CollectionIdCustomType.class);
            if (customType == null) {
                return null;
            }
            return BasicValueBinder.normalizeUserType(customType.value());
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            CollectionIdCustomType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, CollectionIdCustomType.class);
            if (customType == null) {
                return null;
            }
            return customType.parameters();
        }
    }

    private static class MapKeyMappingAccess
    implements BasicMappingAccess {
        public static final MapKeyMappingAccess INSTANCE = new MapKeyMappingAccess();

        private MapKeyMappingAccess() {
        }

        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            MapKeyCustomType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, MapKeyCustomType.class);
            if (customType == null) {
                return null;
            }
            return BasicValueBinder.normalizeUserType(customType.value());
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            MapKeyCustomType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, MapKeyCustomType.class);
            if (customType == null) {
                return null;
            }
            return customType.parameters();
        }
    }

    private static class AnyKeyMappingAccess
    implements BasicMappingAccess {
        public static final AnyKeyMappingAccess INSTANCE = new AnyKeyMappingAccess();
        private static final Parameter[] EMPTY_PARAMS = new Parameter[0];

        private AnyKeyMappingAccess() {
        }

        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            return null;
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            return EMPTY_PARAMS;
        }
    }

    private static class AnyDiscriminatorMappingAccess
    implements BasicMappingAccess {
        public static final AnyDiscriminatorMappingAccess INSTANCE = new AnyDiscriminatorMappingAccess();
        private static final Parameter[] EMPTY_PARAMS = new Parameter[0];

        private AnyDiscriminatorMappingAccess() {
        }

        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            return null;
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            return EMPTY_PARAMS;
        }
    }

    private static class ValueMappingAccess
    implements BasicMappingAccess {
        public static final ValueMappingAccess INSTANCE = new ValueMappingAccess();

        private ValueMappingAccess() {
        }

        public Class<? extends UserType<?>> customType(XProperty xProperty) {
            CustomType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, CustomType.class);
            if (customType == null) {
                return null;
            }
            return BasicValueBinder.normalizeUserType(customType.value());
        }

        @Override
        public Parameter[] customTypeParameters(XProperty xProperty) {
            CustomType customType = HCANNHelper.findAnnotation((XAnnotatedElement)xProperty, CustomType.class);
            if (customType == null) {
                return null;
            }
            return customType.parameters();
        }
    }

    private static interface BasicMappingAccess {
        public Class<? extends UserType> customType(XProperty var1);

        public Parameter[] customTypeParameters(XProperty var1);
    }

    public static enum Kind {
        ATTRIBUTE(ValueMappingAccess.INSTANCE),
        ANY_DISCRIMINATOR(AnyDiscriminatorMappingAccess.INSTANCE),
        ANY_KEY(AnyKeyMappingAccess.INSTANCE),
        MAP_KEY(MapKeyMappingAccess.INSTANCE),
        COLLECTION_ELEMENT(ValueMappingAccess.INSTANCE),
        COLLECTION_ID(CollectionIdMappingAccess.INSTANCE),
        LIST_INDEX(ListIndexMappingAccess.INSTANCE);

        private final BasicMappingAccess mappingAccess;

        private Kind(BasicMappingAccess mappingAccess) {
            this.mappingAccess = mappingAccess;
        }
    }
}

