/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.MapSemantics;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.collection.internal.MapInitializerProducer;

public abstract class AbstractMapSemantics<MKV extends Map<K, V>, K, V>
implements MapSemantics<MKV, K, V> {
    @Override
    public Class<? extends Map> getCollectionJavaType() {
        return Map.class;
    }

    @Override
    public Iterator<K> getKeyIterator(MKV rawMap) {
        if (rawMap == null) {
            return null;
        }
        return rawMap.keySet().iterator();
    }

    @Override
    public void visitKeys(MKV rawMap, Consumer<? super K> action) {
        if (rawMap != null) {
            rawMap.keySet().forEach(action);
        }
    }

    @Override
    public void visitEntries(MKV rawMap, BiConsumer<? super K, ? super V> action) {
        if (rawMap != null) {
            rawMap.forEach(action);
        }
    }

    @Override
    public Iterator<V> getElementIterator(MKV rawMap) {
        if (rawMap == null) {
            return Collections.emptyIterator();
        }
        return rawMap.values().iterator();
    }

    @Override
    public void visitElements(MKV rawMap, Consumer<? super V> action) {
        if (rawMap != null) {
            rawMap.values().forEach(action);
        }
    }

    @Override
    public CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParent fetchParent, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return new MapInitializerProducer(attributeMapping, fetchParent.generateFetchableFetch(attributeMapping.getIndexDescriptor(), navigablePath.append(CollectionPart.Nature.INDEX.getName()), FetchTiming.IMMEDIATE, selected, null, creationState), fetchParent.generateFetchableFetch(attributeMapping.getElementDescriptor(), navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), FetchTiming.IMMEDIATE, selected, null, creationState));
    }

    @Override
    public CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParent fetchParent, boolean selected, String resultVariable, Fetch indexFetch, Fetch elementFetch, DomainResultCreationState creationState) {
        if (indexFetch == null) {
            indexFetch = fetchParent.generateFetchableFetch(attributeMapping.getIndexDescriptor(), navigablePath.append(CollectionPart.Nature.INDEX.getName()), FetchTiming.IMMEDIATE, selected, null, creationState);
        }
        if (elementFetch == null) {
            elementFetch = fetchParent.generateFetchableFetch(attributeMapping.getElementDescriptor(), navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), FetchTiming.IMMEDIATE, selected, null, creationState);
        }
        return new MapInitializerProducer(attributeMapping, indexFetch, elementFetch);
    }
}

