/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Iterator;
import java.util.function.Consumer;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.collection.internal.BagInitializerProducer;
import org.hibernate.sql.results.graph.collection.internal.ListInitializerProducer;
import org.hibernate.sql.results.graph.collection.internal.MapInitializerProducer;
import org.hibernate.type.CollectionType;

public class CustomCollectionTypeSemantics<CE, E>
implements CollectionSemantics<CE, E> {
    private final CollectionType collectionType;

    public CustomCollectionTypeSemantics(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.BAG;
    }

    @Override
    public Class<?> getCollectionJavaType() {
        return this.collectionType.getReturnedClass();
    }

    @Override
    public CE instantiateRaw(int anticipatedSize, CollectionPersister collectionDescriptor) {
        return (CE)this.collectionType.instantiate(anticipatedSize);
    }

    @Override
    public Iterator<E> getElementIterator(CE rawCollection) {
        return this.collectionType.getElementsIterator(rawCollection, null);
    }

    @Override
    public void visitElements(CE rawCollection, Consumer<? super E> action) {
        this.getElementIterator(rawCollection).forEachRemaining(action);
    }

    @Override
    public CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParent fetchParent, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        Fetch indexFetch = attributeMapping.getIndexDescriptor() == null ? null : fetchParent.generateFetchableFetch(attributeMapping.getIndexDescriptor(), navigablePath.append(CollectionPart.Nature.INDEX.getName()), FetchTiming.IMMEDIATE, selected, null, creationState);
        Fetch elementFetch = fetchParent.generateFetchableFetch(attributeMapping.getElementDescriptor(), navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), FetchTiming.IMMEDIATE, selected, null, creationState);
        if (indexFetch == null) {
            return new BagInitializerProducer(attributeMapping, null, elementFetch);
        }
        if (indexFetch.getResultJavaTypeDescriptor().getJavaTypeClass() == Integer.class) {
            return new ListInitializerProducer(attributeMapping, indexFetch, elementFetch);
        }
        return new MapInitializerProducer(attributeMapping, indexFetch, elementFetch);
    }

    @Override
    public CollectionInitializerProducer createInitializerProducer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParent fetchParent, boolean selected, String resultVariable, Fetch indexFetch, Fetch elementFetch, DomainResultCreationState creationState) {
        if (indexFetch == null) {
            indexFetch = fetchParent.generateFetchableFetch(attributeMapping.getIndexDescriptor(), navigablePath.append(CollectionPart.Nature.INDEX.getName()), FetchTiming.IMMEDIATE, selected, null, creationState);
        }
        if (elementFetch == null) {
            elementFetch = fetchParent.generateFetchableFetch(attributeMapping.getElementDescriptor(), navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), FetchTiming.IMMEDIATE, selected, null, creationState);
        }
        if (indexFetch == null) {
            return new BagInitializerProducer(attributeMapping, null, elementFetch);
        }
        if (indexFetch.getResultJavaTypeDescriptor().getJavaTypeClass() == Integer.class) {
            return new ListInitializerProducer(attributeMapping, indexFetch, elementFetch);
        }
        return new MapInitializerProducer(attributeMapping, indexFetch, elementFetch);
    }

    @Override
    public PersistentCollection<E> instantiateWrapper(Object key, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return this.collectionType.instantiate(session, collectionDescriptor, key);
    }

    @Override
    public PersistentCollection<E> wrap(CE rawCollection, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return this.collectionType.wrap(session, rawCollection);
    }
}

