/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.function.CaseLeastGreatestEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.TransactSQLStrFunction;
import org.hibernate.dialect.identity.AbstractTransactSQLIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.NullOrdering;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public abstract class AbstractTransactSQLDialect
extends Dialect {
    public AbstractTransactSQLDialect() {
        this.registerColumnType(16, "bit");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "int");
        this.registerColumnType(91, "datetime");
        this.registerColumnType(92, "datetime");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(2014, "datetime");
        this.registerColumnType(2004, "image");
        this.registerColumnType(2005, "text");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.ln_log(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.atan2_atn2(queryEngine);
        CommonFunctionFactory.mod_operator(queryEngine);
        CommonFunctionFactory.square(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.reverse(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.pad_replicate(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.chr_char(queryEngine);
        CommonFunctionFactory.concat_plusOperator(queryEngine);
        CommonFunctionFactory.trim1(queryEngine);
        CommonFunctionFactory.repeat_replicate(queryEngine);
        CommonFunctionFactory.characterLength_len(queryEngine);
        CommonFunctionFactory.substring_substringLen(queryEngine);
        CommonFunctionFactory.datepartDatename(queryEngine);
        CommonFunctionFactory.lastDay_eomonth(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("least", new CaseLeastGreatestEmulation(true));
        queryEngine.getSqmFunctionRegistry().register("greatest", new CaseLeastGreatestEmulation(false));
        queryEngine.getSqmFunctionRegistry().register("str", new TransactSQLStrFunction(queryEngine.getTypeConfiguration()));
    }

    @Override
    public String trimPattern(TrimSpec specification, char character) {
        return AbstractTransactSQLDialect.replaceLtrimRtrim(specification, character);
    }

    public static String replaceLtrimRtrim(TrimSpec specification, char character) {
        boolean blank = character == ' ';
        switch (specification) {
            case LEADING: {
                return blank ? "ltrim(?1)" : "replace(replace(ltrim(replace(replace(?1,' ','#%#%'),'@',' ')),' ','@'),'#%#%',' ')".replace('@', character);
            }
            case TRAILING: {
                return blank ? "rtrim(?1)" : "replace(replace(rtrim(replace(replace(?1,' ','#%#%'),'@',' ')),' ','@'),'#%#%',' ')".replace('@', character);
            }
        }
        return blank ? "ltrim(rtrim(?1))" : "replace(replace(ltrim(rtrim(replace(replace(?1,' ','#%#%'),'@',' '))),' ','@'),'#%#%',' ')".replace('@', character);
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.TABLE;
    }

    @Override
    public String appendLockHint(LockOptions lockOptions, String tableName) {
        return lockOptions.getLockMode().greaterThan(LockMode.READ) ? tableName + " holdlock" : tableName;
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        Iterator<Map.Entry<String, LockMode>> itr = aliasedLockOptions.getAliasLockIterator();
        StringBuilder buffer = new StringBuilder(sql);
        while (itr.hasNext()) {
            Map.Entry<String, LockMode> entry = itr.next();
            LockMode lockMode = entry.getValue();
            if (!lockMode.greaterThan(LockMode.READ)) continue;
            String alias = entry.getKey();
            int start = -1;
            int end = -1;
            if (sql.endsWith(" " + alias)) {
                start = buffer.length() - alias.length();
                end = start + alias.length();
            } else {
                int position = buffer.indexOf(" " + alias + " ");
                if (position <= -1) {
                    position = buffer.indexOf(" " + alias + ",");
                }
                if (position > -1) {
                    start = position + 1;
                    end = start + alias.length();
                }
            }
            if (start <= -1) continue;
            String lockHint = this.appendLockHint(aliasedLockOptions, alias);
            buffer.replace(start, end, lockHint);
        }
        return buffer.toString();
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select getdate()";
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableStrategy(new IdTable(entityDescriptor, basename -> "#" + basename, this, runtimeModelCreationContext), () -> new TempIdTableExporter(true, this::getTypeName){

            @Override
            protected String getCreateCommand() {
                return "create table";
            }
        }, AfterUseAction.DROP, TempTableDdlTransactionHandling.NONE, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public String getSelectGUIDString() {
        return "select newid()";
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new AbstractTransactSQLIdentityColumnSupport();
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("0x");
        PrimitiveByteArrayJavaTypeDescriptor.INSTANCE.appendString(appender, bytes);
    }
}

