/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.FetchClauseType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2SqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public DB2SqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        if (this.getDialect().getVersion() >= 1100) {
            booleanExpressionPredicate.getExpression().accept(this);
        } else {
            super.visitBooleanExpressionPredicate(booleanExpressionPredicate);
        }
    }

    @Override
    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    @Override
    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    @Override
    protected String getForUpdate() {
        return " for read only with rs use and keep update locks";
    }

    @Override
    protected String getForShare(int timeoutMillis) {
        return " for read only with rs use and keep share locks";
    }

    @Override
    protected String getSkipLocked() {
        return " skip locked data";
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.getQueryPartForRowNumbering() != queryPart && (this.useOffsetFetchClause(queryPart) && !this.isRowsOnlyFetchClauseType(queryPart) || this.getDialect().getVersion() < 1110 && (queryPart.isRoot() && this.hasLimit() || !(queryPart.getFetchClauseExpression() instanceof Literal)));
    }

    protected boolean supportsOffsetClause() {
        return this.getDialect().getVersion() >= 1110;
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        boolean emulateFetchClause = this.shouldEmulateFetchClause(queryGroup);
        if (emulateFetchClause || !this.supportsOffsetClause() && this.hasOffset(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, emulateFetchClause);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        boolean emulateFetchClause = this.shouldEmulateFetchClause(querySpec);
        if (emulateFetchClause || !this.supportsOffsetClause() && this.hasOffset(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, emulateFetchClause);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetClause() || !this.hasOffset(queryPart)) {
                this.renderOffsetFetchClause(queryPart, true);
            } else if (queryPart.isRoot() && this.hasLimit()) {
                this.renderFetch(this.getLimitParameter(), null, FetchClauseType.ROWS_ONLY);
            } else if (queryPart.getFetchClauseExpression() != null) {
                this.renderFetch(queryPart.getFetchClauseExpression(), null, queryPart.getFetchClauseType());
            }
        }
    }

    @Override
    protected void visitDeleteStatementOnly(DeleteStatement statement) {
        boolean closeWrapper = this.renderReturningClause(statement);
        super.visitDeleteStatementOnly(statement);
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    @Override
    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        boolean closeWrapper = this.renderReturningClause(statement);
        super.visitUpdateStatementOnly(statement);
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    @Override
    protected void visitInsertStatementOnly(InsertStatement statement) {
        boolean closeWrapper = this.renderReturningClause(statement);
        super.visitInsertStatementOnly(statement);
        if (closeWrapper) {
            this.appendSql(')');
        }
    }

    protected boolean renderReturningClause(MutationStatement statement) {
        List<ColumnReference> returningColumns = statement.getReturningColumns();
        int size = returningColumns.size();
        if (size == 0) {
            return false;
        }
        this.appendSql("select ");
        String separator = "";
        for (int i = 0; i < size; ++i) {
            this.appendSql(separator);
            this.appendSql(returningColumns.get(i).getColumnExpression());
            separator = ",";
        }
        if (statement instanceof DeleteStatement) {
            this.appendSql(" from old table (");
        } else {
            this.appendSql(" from final table (");
        }
        return true;
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        if (this.getDialect().getVersion() >= 1110) {
            this.renderComparisonStandard(lhs, operator, rhs);
        } else {
            this.renderComparisonEmulateDecode(lhs, operator, rhs);
        }
    }

    @Override
    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected String getFromDual() {
        return " from sysibm.dual";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    @Override
    protected void visitReturningColumns(MutationStatement mutationStatement) {
    }
}

