/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class H2SqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public H2SqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        booleanExpressionPredicate.getExpression().accept(this);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.isRowsOnlyFetchClauseType(queryPart)) {
            if (this.supportsOffsetFetchClause()) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.renderLimitOffsetClause(queryPart);
            }
        } else if (this.supportsOffsetFetchClausePercentWithTies()) {
            this.renderOffsetFetchClause(queryPart, true);
        } else {
            throw new IllegalArgumentException("Can't emulate fetch clause type: " + queryPart.getFetchClauseType());
        }
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected String getFromDual() {
        return " from dual";
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion() >= 104195;
    }

    private boolean supportsOffsetFetchClausePercentWithTies() {
        return this.getDialect().getVersion() >= 104198;
    }
}

