/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.PhysicalIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.type.StandardBasicTypes;

public class HANAColumnStoreDialect
extends AbstractHANADialect {
    private final int version;

    public HANAColumnStoreDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
        this.registerKeywords(info);
    }

    public HANAColumnStoreDialect() {
        this(300);
    }

    public HANAColumnStoreDialect(int version) {
        this.version = version;
        if (this.version >= 400) {
            this.registerColumnType(1, "nvarchar(1)");
            this.registerColumnType(12, 5000L, "nvarchar($l)");
            this.registerColumnType(-1, 5000L, "nvarchar($l)");
            this.registerColumnType(-1, "nclob");
            this.registerColumnType(12, "nclob");
            this.registerColumnType(2005, "nclob");
            this.registerHibernateType(2005, StandardBasicTypes.MATERIALIZED_NCLOB.getName());
            this.registerHibernateType(-15, StandardBasicTypes.NSTRING.getName());
            this.registerHibernateType(1, StandardBasicTypes.CHARACTER.getName());
            this.registerHibernateType(1, 1L, StandardBasicTypes.CHARACTER.getName());
            this.registerHibernateType(1, 5000L, StandardBasicTypes.NSTRING.getName());
            this.registerHibernateType(12, StandardBasicTypes.NSTRING.getName());
            this.registerHibernateType(-1, StandardBasicTypes.NTEXT.getName());
            this.registerHanaCloudKeywords();
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private void registerHanaCloudKeywords() {
        this.registerKeyword("array");
        this.registerKeyword("at");
        this.registerKeyword("authorization");
        this.registerKeyword("between");
        this.registerKeyword("by");
        this.registerKeyword("collate");
        this.registerKeyword("empty");
        this.registerKeyword("filter");
        this.registerKeyword("grouping");
        this.registerKeyword("no");
        this.registerKeyword("not");
        this.registerKeyword("of");
        this.registerKeyword("over");
        this.registerKeyword("recursive");
        this.registerKeyword("row");
        this.registerKeyword("table");
        this.registerKeyword("to");
        this.registerKeyword("window");
        this.registerKeyword("within");
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        queryEngine.getSqmFunctionRegistry().registerNamed("score", queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE));
        queryEngine.getSqmFunctionRegistry().registerNamed("snippets");
        queryEngine.getSqmFunctionRegistry().registerNamed("highlighted");
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("contains", queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN), "contains(?1,?2)", "contains(?1,?2,?3)");
    }

    @Override
    public String getCreateTableString() {
        return "create column table";
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableStrategy(new IdTable(entityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), () -> new PhysicalIdTableExporter(){

            @Override
            protected String getCreateCommand() {
                return "create global temporary column table";
            }

            @Override
            protected String getTruncateIdTableCommand() {
                return "truncate table";
            }

            @Override
            public String getCreateOptions() {
                return "on commit delete rows";
            }
        }, AfterUseAction.CLEAN, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    protected boolean supportsAsciiStringTypes() {
        return this.version < 400;
    }

    @Override
    protected Boolean useUnicodeStringTypesDefault() {
        if (this.version >= 400) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean isUseUnicodeStringTypes() {
        if (this.version >= 400) {
            return true;
        }
        return super.isUseUnicodeStringTypes();
    }
}

