/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.InnoDBStorageEngine;
import org.hibernate.dialect.MariaDBSqlAstTranslator;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.MySQLStorageEngine;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.sequence.MariaDBSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorMariaDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;

public class MariaDBDialect
extends MySQLDialect {
    private final int version;

    public MariaDBDialect() {
        this(500);
    }

    public MariaDBDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10, MariaDBDialect.getCharacterSetBytesPerCharacter(info.unwrap(DatabaseMetaData.class)));
        this.registerKeywords(info);
    }

    public MariaDBDialect(int version) {
        this(version, 4);
    }

    public MariaDBDialect(int version, int characterSetBytesPerCharacter) {
        super(version < 530 ? 500 : 570, characterSetBytesPerCharacter);
        this.version = version;
    }

    @Override
    protected int getMaxVarcharLen() {
        return this.getMySQLVersion() < 500 ? 255 : 65534;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        if (this.getVersion() >= 1020) {
            queryEngine.getSqmFunctionRegistry().registerNamed("json_valid", queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN));
        }
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new MariaDBSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getVersion() >= 1020;
    }

    @Override
    public boolean supportsColumnCheck() {
        return this.getVersion() >= 1020;
    }

    @Override
    protected MySQLStorageEngine getDefaultMySQLStorageEngine() {
        return InnoDBStorageEngine.INSTANCE;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getVersion() >= 1000;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.getVersion() >= 1050;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion() < 1030 ? super.getSequenceSupport() : MariaDBSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getSequenceSupport().supportsSequences() ? "select table_name from information_schema.TABLES where table_schema=database() and table_type='SEQUENCE'" : super.getQuerySequencesString();
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getSequenceSupport().supportsSequences() ? SequenceInformationExtractorMariaDBDatabaseImpl.INSTANCE : super.getSequenceInformationExtractor();
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getVersion() >= 1060;
    }

    @Override
    public boolean supportsNoWait() {
        return this.getVersion() >= 1030;
    }

    @Override
    public boolean supportsWait() {
        return this.getVersion() >= 1030;
    }

    @Override
    boolean supportsForShare() {
        return false;
    }

    @Override
    boolean supportsAliasLocks() {
        return false;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }
}

